"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorErrorsCount = exports.ERRORS_LABEL = void 0;
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _public2 = require("@kbn/exploratory-view-plugin/public");
var _i18n = require("@kbn/i18n");
var _use_selected_location = require("../hooks/use_selected_location");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorErrorsCount = ({
  monitorId,
  from,
  to,
  id
}) => {
  const {
    exploratoryView: {
      ExploratoryViewEmbeddable
    }
  } = (0, _public.useKibana)().services;
  const selectedLocation = (0, _use_selected_location.useSelectedLocation)();
  const time = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);
  if (!selectedLocation || !monitorId) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    id: id,
    align: "left",
    customHeight: "70px",
    reportType: _public2.ReportTypes.SINGLE_METRIC,
    attributes: [{
      time,
      reportDefinitions: {
        'monitor.id': monitorId,
        'observer.geo.name': [selectedLocation === null || selectedLocation === void 0 ? void 0 : selectedLocation.label]
      },
      dataType: 'synthetics',
      selectedMetricField: 'monitor_errors',
      name: ERRORS_LABEL
    }]
  });
};
exports.MonitorErrorsCount = MonitorErrorsCount;
const ERRORS_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorDetails.summary.errors', {
  defaultMessage: 'Errors'
});
exports.ERRORS_LABEL = ERRORS_LABEL;