"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WrapperStyle = exports.MonitorDetailsPanelContainer = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _common = require("@kbn/kibana-react-plugin/common");
var _monitor_details_panel = require("../../common/components/monitor_details_panel");
var _use_selected_monitor = require("../hooks/use_selected_monitor");
var _runtime_types = require("../../../../../../common/runtime_types");
var _use_monitor_latest_ping = require("../hooks/use_monitor_latest_ping");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorDetailsPanelContainer = props => {
  const {
    latestPing
  } = (0, _use_monitor_latest_ping.useMonitorLatestPing)();
  const {
    monitorId: configId
  } = (0, _reactRouterDom.useParams)();
  const {
    monitor,
    loading
  } = (0, _use_selected_monitor.useSelectedMonitor)();
  if (latestPing && (latestPing === null || latestPing === void 0 ? void 0 : latestPing.config_id) !== configId || monitor && monitor[_runtime_types.ConfigKey.CONFIG_ID] !== configId) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 6
    });
  }
  return /*#__PURE__*/_react.default.createElement(_monitor_details_panel.MonitorDetailsPanel, (0, _extends2.default)({
    latestPing: latestPing,
    monitor: monitor,
    loading: loading,
    configId: configId
  }, props));
};
exports.MonitorDetailsPanelContainer = MonitorDetailsPanelContainer;
const WrapperStyle = _common.euiStyled.div`
  .euiDescriptionList.euiDescriptionList--column > *,
  .euiDescriptionList.euiDescriptionList--responsiveColumn > * {
    margin-top: ${({
  theme
}) => theme.eui.euiSizeS};
  }
`;
exports.WrapperStyle = WrapperStyle;