"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorCompleteSparklines = void 0;
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _monitor_complete_count = require("./monitor_complete_count");
var _use_monitor_query_id = require("../hooks/use_monitor_query_id");
var _use_selected_location = require("../hooks/use_selected_location");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorCompleteSparklines = props => {
  const {
    exploratoryView: {
      ExploratoryViewEmbeddable
    }
  } = (0, _public.useKibana)().services;
  const monitorId = (0, _use_monitor_query_id.useMonitorQueryId)();
  const selectedLocation = (0, _use_selected_location.useSelectedLocation)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (!monitorId || !selectedLocation) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(ExploratoryViewEmbeddable, {
    id: "monitorSuccessfulSparklines",
    reportType: "kpi-over-time",
    axisTitlesVisibility: {
      x: false,
      yRight: false,
      yLeft: false
    },
    legendIsVisible: false,
    hideTicks: true,
    attributes: [{
      seriesType: 'area',
      time: props,
      reportDefinitions: {
        'monitor.id': [monitorId],
        'observer.geo.name': [selectedLocation.label]
      },
      dataType: 'synthetics',
      selectedMetricField: 'monitor_successful',
      name: _monitor_complete_count.SUCCESSFUL_LABEL,
      color: euiTheme.colors.success,
      operationType: 'unique_count'
    }]
  });
};
exports.MonitorCompleteSparklines = MonitorCompleteSparklines;