"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MonitorStatusLegend = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var labels = _interopRequireWildcard(require("./labels"));
var _monitor_status_data = require("./monitor_status_data");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorStatusLegend = ({
  brushable
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const LegendItem = (0, _react.useMemo)(() => {
    return ({
      color,
      label,
      iconType = 'dot'
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      css: {
        display: 'flex',
        flexDirection: 'row',
        gap: 2
      },
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: iconType,
      color: color
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, label));
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(LegendItem, {
    color: _monitor_status_data.SUCCESS_VIZ_COLOR,
    label: labels.COMPLETE_LABEL
  }), /*#__PURE__*/_react.default.createElement(LegendItem, {
    color: _monitor_status_data.DANGER_VIZ_COLOR,
    label: labels.FAILED_LABEL
  }), /*#__PURE__*/_react.default.createElement(LegendItem, {
    color: (0, _monitor_status_data.getSkippedVizColor)(euiTheme),
    label: labels.SKIPPED_LABEL
  }), brushable ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "aria-hidden": true,
    grow: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: euiTheme.colors.subduedText
  }, labels.BRUSH_AREA_MESSAGE))) : null);
};
exports.MonitorStatusLegend = MonitorStatusLegend;