"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMonitorRangeFrom = void 0;
var _react = require("react");
var _moment = _interopRequireDefault(require("moment"));
var _hooks = require("../../../hooks");
var _use_selected_monitor = require("./use_selected_monitor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useMonitorRangeFrom = () => {
  const {
    monitor,
    loading
  } = (0, _use_selected_monitor.useSelectedMonitor)();
  const {
    from,
    to
  } = (0, _hooks.useRefreshedRange)(30, 'days');
  return (0, _react.useMemo)(() => {
    if (monitor !== null && monitor !== void 0 && monitor.created_at) {
      const diff = (0, _moment.default)(monitor === null || monitor === void 0 ? void 0 : monitor.created_at).diff((0, _moment.default)().subtract(30, 'day'), 'days');
      if (diff > 0) {
        return {
          to,
          from: monitor === null || monitor === void 0 ? void 0 : monitor.created_at,
          loading
        };
      }
    }
    return {
      to,
      from,
      loading
    };
  }, [monitor === null || monitor === void 0 ? void 0 : monitor.created_at, to, from, loading]);
};
exports.useMonitorRangeFrom = useMonitorRangeFrom;