"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ControlledField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _reactHookForm = require("react-hook-form");
var _hooks = require("../hooks");
var _state = require("../../../state");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const setFieldValue = (key, setValue) => value => {
  setValue(key, value);
};
const ControlledField = ({
  component: FieldComponent,
  props,
  fieldKey,
  shouldUseSetValue,
  field,
  formRowProps,
  fieldState,
  customHook,
  error,
  dependenciesValues,
  dependenciesFieldMeta
}) => {
  var _hookProps, _hookProps2, _hookProps3, _hookProps4, _fieldState$error2;
  const {
    setValue,
    reset,
    formState,
    setError,
    clearErrors
  } = (0, _reactHookForm.useFormContext)();
  const noop = () => {};
  let hook = noop;
  let hookProps;
  const {
    locations
  } = (0, _reactRedux.useSelector)(_state.selectServiceLocationsState);
  const {
    space
  } = (0, _hooks.useKibanaSpace)();
  const isEdit = (0, _hooks.useIsEditFlow)();
  if (customHook) {
    hookProps = customHook(field.value);
    hook = hookProps.func;
  }
  const {
    [(_hookProps = hookProps) === null || _hookProps === void 0 ? void 0 : _hookProps.fieldKey]: hookResult
  } = hook((_hookProps2 = hookProps) === null || _hookProps2 === void 0 ? void 0 : _hookProps2.params) || {};
  const onChange = shouldUseSetValue ? setFieldValue(fieldKey, setValue) : field.onChange;
  const generatedProps = props ? props({
    field,
    setValue,
    reset,
    locations: locations.map(location => ({
      ...location,
      key: location.id
    })),
    dependencies: dependenciesValues,
    dependenciesFieldMeta,
    space: space === null || space === void 0 ? void 0 : space.id,
    isEdit,
    formState
  }) : {};
  const isInvalid = hookResult || Boolean(fieldState.error);
  const hookErrorContent = (_hookProps3 = hookProps) === null || _hookProps3 === void 0 ? void 0 : _hookProps3.error;
  const hookError = hookResult ? (_hookProps4 = hookProps) === null || _hookProps4 === void 0 ? void 0 : _hookProps4.error : undefined;
  (0, _react.useEffect)(() => {
    var _fieldState$error;
    if (!customHook) {
      return;
    }
    if (hookResult && !fieldState.error) {
      setError(fieldKey, {
        type: 'custom',
        message: hookErrorContent
      });
    } else if (!hookResult && ((_fieldState$error = fieldState.error) === null || _fieldState$error === void 0 ? void 0 : _fieldState$error.message) === hookErrorContent) {
      clearErrors(fieldKey);
    }
  }, [setError, fieldKey, clearErrors, fieldState, customHook, hookResult, hookErrorContent]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({}, formRowProps, {
    isInvalid: isInvalid,
    error: isInvalid ? hookError || ((_fieldState$error2 = fieldState.error) === null || _fieldState$error2 === void 0 ? void 0 : _fieldState$error2.message) || error : undefined
  }), /*#__PURE__*/_react.default.createElement(FieldComponent, (0, _extends2.default)({}, field, {
    checked: field.value || false,
    defaultValue: field.value,
    onChange: onChange
  }, generatedProps, {
    isInvalid: isInvalid,
    fullWidth: true
  })));
};
exports.ControlledField = ControlledField;