"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResponseBodyIndexField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _types = require("../types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ResponseBodyIndexField = ({
  defaultValue,
  onChange,
  onBlur,
  readOnly
}) => {
  const [policy, setPolicy] = (0, _react.useState)(defaultValue !== _types.ResponseBodyIndexPolicy.NEVER ? defaultValue : _types.ResponseBodyIndexPolicy.ON_ERROR);
  const [checked, setChecked] = (0, _react.useState)(defaultValue !== _types.ResponseBodyIndexPolicy.NEVER);
  (0, _react.useEffect)(() => {
    if (checked) {
      setPolicy(policy);
      onChange(policy);
    } else {
      onChange(_types.ResponseBodyIndexPolicy.NEVER);
    }
  }, [checked, policy, setPolicy, onChange]);
  (0, _react.useEffect)(() => {
    onChange(policy);
  }, [onChange, policy]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "syntheticsIndexResponseBody"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    id: "uptimeFleetIndexResponseBody",
    checked: checked,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.synthetics.monitorConfig.indexResponseBody.label",
      defaultMessage: "Index response body"
    }),
    onChange: event => {
      const checkedEvent = event.target.checked;
      setChecked(checkedEvent);
    },
    onBlur: () => onBlur === null || onBlur === void 0 ? void 0 : onBlur(),
    disabled: readOnly
  })), checked && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "aria-label": _i18n.i18n.translate('xpack.synthetics.monitorConfig.indexResponseBodyPolicy.label', {
      defaultMessage: 'Response body index policy'
    }),
    "data-test-subj": "indexResponseBodyFieldSelect",
    options: responseBodyIndexPolicyOptions,
    value: policy,
    onChange: event => {
      setPolicy(event.target.value);
    },
    onBlur: () => onBlur === null || onBlur === void 0 ? void 0 : onBlur(),
    disabled: readOnly
  })));
};
exports.ResponseBodyIndexField = ResponseBodyIndexField;
const responseBodyIndexPolicyOptions = [{
  value: _types.ResponseBodyIndexPolicy.ALWAYS,
  text: _i18n.i18n.translate('xpack.synthetics.createPackagePolicy.stepConfigure.responseBodyIndex.always', {
    defaultMessage: 'Always'
  })
}, {
  value: _types.ResponseBodyIndexPolicy.ON_ERROR,
  text: _i18n.i18n.translate('xpack.synthetics.createPackagePolicy.stepConfigure.responseBodyIndex.onError', {
    defaultMessage: 'On error'
  })
}];