"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorStartedAt = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_last_error_state = require("../hooks/use_last_error_state");
var _use_date_format = require("../../../../../hooks/use_date_format");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ErrorStartedAt = () => {
  var _failedTests$;
  const {
    failedTests
  } = (0, _use_last_error_state.useErrorFailedTests)();
  const state = failedTests === null || failedTests === void 0 ? void 0 : (_failedTests$ = failedTests[0]) === null || _failedTests$ === void 0 ? void 0 : _failedTests$.state;
  const formatter = (0, _use_date_format.useDateFormat)();
  let startedAt = formatter(state === null || state === void 0 ? void 0 : state.started_at);
  if (!startedAt) {
    startedAt = /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 1
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    listItems: [{
      title: ERROR_DURATION,
      description: startedAt
    }]
  });
};
exports.ErrorStartedAt = ErrorStartedAt;
const ERROR_DURATION = _i18n.i18n.translate('xpack.synthetics.errorDetails.startedAt', {
  defaultMessage: 'Started at'
});