"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.THUMBNAIL_SCREENSHOT_SIZE_MOBILE = exports.THUMBNAIL_SCREENSHOT_SIZE = exports.POPOVER_SCREENSHOT_SIZE = void 0;
exports.getConfinedScreenshotSize = getConfinedScreenshotSize;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const THUMBNAIL_SCREENSHOT_SIZE = [96, 64];
exports.THUMBNAIL_SCREENSHOT_SIZE = THUMBNAIL_SCREENSHOT_SIZE;
const THUMBNAIL_SCREENSHOT_SIZE_MOBILE = [180, 112];
exports.THUMBNAIL_SCREENSHOT_SIZE_MOBILE = THUMBNAIL_SCREENSHOT_SIZE_MOBILE;
const POPOVER_SCREENSHOT_SIZE = [640, 360];
exports.POPOVER_SCREENSHOT_SIZE = POPOVER_SCREENSHOT_SIZE;
function getConfinedScreenshotSize(size, maxSize) {
  const constrainedWidth = '86vw';
  const constrainedHeight = '70vh';
  const maxWidth = maxSize !== null && maxSize !== void 0 && maxSize[0] ? `${maxSize[0]}px` : constrainedWidth;
  const maxHeight = maxSize !== null && maxSize !== void 0 && maxSize[1] ? `${maxSize[1]}px` : constrainedHeight;
  const width = size === 'full' ? maxWidth : `${size[0]}px`;
  const height = size === 'full' ? maxHeight : `${size[1]}px`;
  return {
    width: `min(${width}, ${constrainedWidth})`,
    height: `min(${height}, ${constrainedHeight})`
  };
}