"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SOURCE_CODE_LABEL = exports.MonitorInspectWrapper = exports.INSPECT_MONITOR_LABEL = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/observability-plugin/common");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _contexts = require("../../../contexts");
var _monitor_detail_flyout = require("../../monitors_page/overview/overview/monitor_detail_flyout");
var _runtime_types = require("../../../../../../common/runtime_types");
var _api = require("../../../state/monitor_management/api");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MonitorInspectWrapper = () => {
  const {
    services: {
      uiSettings
    }
  } = (0, _public.useKibana)();
  const {
    isDev
  } = (0, _contexts.useSyntheticsSettingsContext)();
  const isInspectorEnabled = uiSettings === null || uiSettings === void 0 ? void 0 : uiSettings.get(_common.enableInspectEsQueries);
  return isDev || isInspectorEnabled ? /*#__PURE__*/_react.default.createElement(MonitorInspect, null) : null;
};
exports.MonitorInspectWrapper = MonitorInspectWrapper;
const MonitorInspect = () => {
  const {
    isDev
  } = (0, _contexts.useSyntheticsSettingsContext)();
  const [hideParams, setHideParams] = (0, _react.useState)(() => !isDev);
  const [isFlyoutVisible, setIsFlyoutVisible] = (0, _react.useState)(false);
  const closeFlyout = () => {
    setIsFlyoutVisible(false);
    setIsInspecting(false);
  };
  const [isInspecting, setIsInspecting] = (0, _react.useState)(false);
  const onButtonClick = () => {
    setIsInspecting(() => !isInspecting);
    setIsFlyoutVisible(() => !isFlyoutVisible);
  };
  const {
    getValues,
    formState
  } = (0, _reactHookForm.useFormContext)();
  const {
    data,
    loading,
    error
  } = (0, _public2.useFetcher)(() => {
    if (isInspecting) {
      return (0, _api.inspectMonitorAPI)({
        hideParams,
        monitor: getValues()
      });
    }
  }, [isInspecting, hideParams]);
  let flyout;
  if (isFlyoutVisible) {
    flyout = /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
      ownFocus: true,
      onClose: closeFlyout,
      "aria-labelledby": "flyoutTitle"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
      hasBorder: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "m"
    }, /*#__PURE__*/_react.default.createElement("h2", {
      id: "flyoutTitle"
    }, CONFIG_LABEL))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
      label: HIDE_PARAMS,
      checked: hideParams,
      onChange: e => setHideParams(e.target.checked)
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), !loading && data ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "json",
      fontSize: "m",
      paddingSize: "m",
      lineNumbers: true,
      isCopyable: true
    }, formatContent(data.result)), data.decodedCode && /*#__PURE__*/_react.default.createElement(MonitorCode, {
      code: data.decodedCode
    })) : loading && !error ? /*#__PURE__*/_react.default.createElement(_monitor_detail_flyout.LoadingState, null) : /*#__PURE__*/_react.default.createElement("p", null, error === null || error === void 0 ? void 0 : error.message)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "syntheticsMonitorInspectCloseButton",
      onClick: closeFlyout,
      fill: true
    }, CLOSE_LABEL)));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: formState.isValid ? FORMATTED_CONFIG_DESCRIPTION : VALID_CONFIG_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: !formState.isValid,
    "data-test-subj": "syntheticsMonitorInspectShowFlyoutExampleButton",
    onClick: onButtonClick,
    iconType: "inspect",
    iconSide: "left"
  }, INSPECT_MONITOR_LABEL)), flyout);
};

// @ts-ignore: Unused variable
// tslint:disable-next-line: no-unused-variable
const MonitorCode = ({
  code
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("h2", {
  id: "flyoutTitle"
}, SOURCE_CODE_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
  language: "javascript",
  fontSize: "m",
  paddingSize: "m",
  lineNumbers: true,
  isCopyable: true
}, code));
const formatContent = result => {
  var _result$publicConfigs, _result$publicConfigs2, _result$publicConfigs3, _result$privateConfig, _currentInput$streams;
  const firstResult = (_result$publicConfigs = result.publicConfigs) === null || _result$publicConfigs === void 0 ? void 0 : (_result$publicConfigs2 = _result$publicConfigs[0]) === null || _result$publicConfigs2 === void 0 ? void 0 : (_result$publicConfigs3 = _result$publicConfigs2.monitors) === null || _result$publicConfigs3 === void 0 ? void 0 : _result$publicConfigs3[0];
  const currentInput = (_result$privateConfig = result.privateConfig) === null || _result$privateConfig === void 0 ? void 0 : _result$privateConfig.inputs.find(input => input.enabled);
  const compiledConfig = currentInput === null || currentInput === void 0 ? void 0 : (_currentInput$streams = currentInput.streams.find(stream => Object.values(_runtime_types.DataStream).includes(stream.data_stream.dataset))) === null || _currentInput$streams === void 0 ? void 0 : _currentInput$streams.compiled_stream;
  return JSON.stringify({
    publicConfig: firstResult !== null && firstResult !== void 0 ? firstResult : {},
    privateConfig: compiledConfig !== null && compiledConfig !== void 0 ? compiledConfig : {}
  }, null, 2);
};
const CONFIG_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorInspect.configLabel', {
  defaultMessage: 'Configuration'
});
const VALID_CONFIG_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorInspect.formattedConfigLabel.valid', {
  defaultMessage: 'Only valid form configurations can be inspected.'
});
const FORMATTED_CONFIG_DESCRIPTION = _i18n.i18n.translate('xpack.synthetics.monitorInspect.formattedConfigLabel.description', {
  defaultMessage: 'View formatted configuration for this monitor.'
});
const CLOSE_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorInspect.closeLabel', {
  defaultMessage: 'Close'
});
const SOURCE_CODE_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorInspect.sourceCodeLabel', {
  defaultMessage: 'Source code'
});
exports.SOURCE_CODE_LABEL = SOURCE_CODE_LABEL;
const INSPECT_MONITOR_LABEL = _i18n.i18n.translate('xpack.synthetics.monitorInspect.inspectLabel', {
  defaultMessage: 'Inspect configuration'
});
exports.INSPECT_MONITOR_LABEL = INSPECT_MONITOR_LABEL;
const HIDE_PARAMS = _i18n.i18n.translate('xpack.synthetics.monitorInspect.hideParams', {
  defaultMessage: 'Hide params values'
});