"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CertificatesPage = void 0;
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _certificates = require("../../state/certificates/certificates");
var _cert_search = require("./cert_search");
var _use_cert_search = require("./use_cert_search");
var _certificates_list = require("./certificates_list");
var _hooks = require("../../hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_PAGE_SIZE = 10;
const LOCAL_STORAGE_KEY = 'xpack.uptime.certList.pageSize';
const getPageSizeValue = () => {
  var _localStorage$getItem;
  const value = parseInt((_localStorage$getItem = localStorage.getItem(LOCAL_STORAGE_KEY)) !== null && _localStorage$getItem !== void 0 ? _localStorage$getItem : '', 10);
  if (isNaN(value)) {
    return DEFAULT_PAGE_SIZE;
  }
  return value;
};
const CertificatesPage = () => {
  (0, _public.useTrackPageview)({
    app: 'synthetics',
    path: 'certificates'
  });
  (0, _public.useTrackPageview)({
    app: 'synthetics',
    path: 'certificates',
    delay: 15000
  });
  (0, _hooks.useBreadcrumbs)([{
    text: 'Certificates'
  }]);
  const [page, setPage] = (0, _react.useState)({
    index: 0,
    size: getPageSizeValue()
  });
  const [sort, setSort] = (0, _react.useState)({
    field: 'not_after',
    direction: 'asc'
  });
  const [search, setSearch] = (0, _react.useState)('');
  const dispatch = (0, _reactRedux.useDispatch)();
  const certificates = (0, _use_cert_search.useCertSearch)({
    search,
    size: page.size,
    pageIndex: page.index,
    sortBy: sort.field,
    direction: sort.direction
  });
  (0, _react.useEffect)(() => {
    dispatch((0, _certificates.setCertificatesTotalAction)({
      total: certificates.total
    }));
  }, [certificates.total, dispatch]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_cert_search.CertificateSearch, {
    setSearch: setSearch
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_certificates_list.CertificateList, {
    page: page,
    onChange: (pageVal, sortVal) => {
      setPage(pageVal);
      setSort(sortVal);
      localStorage.setItem(LOCAL_STORAGE_KEY, pageVal.size.toString());
    },
    sort: sort,
    certificates: certificates
  }));
};
exports.CertificatesPage = CertificatesPage;