"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CertStatus = void 0;
var _react = _interopRequireDefault(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_cert_status = require("./use_cert_status");
var _constants = require("../../../../../common/constants");
var labels = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DateText = (0, _styledComponents.default)(_eui.EuiText)`
  display: inline-block;
  margin-left: 5px;
`;
const CertStatus = ({
  cert
}) => {
  const certStatus = (0, _use_cert_status.useCertStatus)(cert === null || cert === void 0 ? void 0 : cert.not_after, cert === null || cert === void 0 ? void 0 : cert.not_before);
  const relativeDate = (0, _moment.default)(cert === null || cert === void 0 ? void 0 : cert.not_after).fromNow();
  if (certStatus === _constants.CERT_STATUS.EXPIRING_SOON) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: "warning"
    }, /*#__PURE__*/_react.default.createElement("span", null, labels.EXPIRES_SOON, '  ', /*#__PURE__*/_react.default.createElement(DateText, {
      color: "subdued",
      size: "xs"
    }, relativeDate)));
  }
  if (certStatus === _constants.CERT_STATUS.EXPIRED) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: "danger"
    }, /*#__PURE__*/_react.default.createElement("span", null, labels.EXPIRED, '  ', /*#__PURE__*/_react.default.createElement(DateText, {
      color: "subdued",
      size: "xs"
    }, relativeDate)));
  }
  if (certStatus === _constants.CERT_STATUS.TOO_OLD) {
    const ageThreshold = _constants.DYNAMIC_SETTINGS_DEFAULTS.certAgeThreshold;
    const oldRelativeDate = (0, _moment.default)(cert === null || cert === void 0 ? void 0 : cert.not_before).add(ageThreshold, 'days').fromNow();
    return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
      color: "danger"
    }, /*#__PURE__*/_react.default.createElement("span", null, labels.TOO_OLD, /*#__PURE__*/_react.default.createElement(DateText, {
      color: "subdued",
      size: "xs"
    }, oldRelativeDate)));
  }
  const okRelativeDate = (0, _moment.default)(cert === null || cert === void 0 ? void 0 : cert.not_after).fromNow(true);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "success"
  }, /*#__PURE__*/_react.default.createElement("span", null, labels.OK, '  ', /*#__PURE__*/_react.default.createElement(DateText, {
    color: "subdued",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.synthetics.certs.status.ok.label",
    defaultMessage: " for {okRelativeDate}",
    description: "Denotes an amount of time for which a cert is valid. Example: \"OK for 2 days\"",
    values: {
      okRelativeDate
    }
  }))));
};
exports.CertStatus = CertStatus;