"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.toggleStatusAlert = exports.isStatusEnabled = exports.AlertConfigsCodec = exports.AlertConfigCodec = void 0;
var t = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertConfigCodec = t.intersection([t.interface({
  enabled: t.boolean
}), t.partial({
  groupBy: t.string
})]);
exports.AlertConfigCodec = AlertConfigCodec;
const AlertConfigsCodec = t.partial({
  tls: AlertConfigCodec,
  status: AlertConfigCodec
});
exports.AlertConfigsCodec = AlertConfigsCodec;
const toggleStatusAlert = (configs = {}) => {
  var _configs$status;
  if ((_configs$status = configs.status) !== null && _configs$status !== void 0 && _configs$status.enabled) {
    return {
      ...configs,
      status: {
        ...configs.status,
        enabled: false
      }
    };
  }
  return {
    ...configs,
    status: {
      enabled: true
    }
  };
};
exports.toggleStatusAlert = toggleStatusAlert;
const isStatusEnabled = (configs = {}) => {
  var _configs$status$enabl, _configs$status2;
  return (_configs$status$enabl = (_configs$status2 = configs.status) === null || _configs$status2 === void 0 ? void 0 : _configs$status2.enabled) !== null && _configs$status$enabl !== void 0 ? _configs$status$enabl : false;
};
exports.isStatusEnabled = isStatusEnabled;