"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sleep = exports.list = exports.generator = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const list = size => Array.from({
  length: size
}, (_, i) => i);
exports.list = list;
const sleep = ms => new Promise(r => setTimeout(r, ms));
exports.sleep = sleep;
const generator = function* (size) {
  for (const n of list(size)) {
    yield n;
  }
};
exports.generator = generator;