"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GenAiConnector = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _server = require("@kbn/actions-plugin/server");
var _create_dashboard = require("./create_dashboard");
var _schema = require("../../../common/gen_ai/schema");
var _constants = require("../../../common/gen_ai/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class GenAiConnector extends _server.SubActionConnector {
  constructor(params) {
    super(params);
    (0, _defineProperty2.default)(this, "url", void 0);
    (0, _defineProperty2.default)(this, "provider", void 0);
    (0, _defineProperty2.default)(this, "key", void 0);
    this.url = this.config.apiUrl;
    this.provider = this.config.apiProvider;
    this.key = this.secrets.apiKey;
    this.registerSubActions();
  }
  registerSubActions() {
    this.registerSubAction({
      name: _constants.SUB_ACTION.RUN,
      method: 'runApi',
      schema: _schema.GenAiRunActionParamsSchema
    });
    this.registerSubAction({
      name: _constants.SUB_ACTION.TEST,
      method: 'runApi',
      schema: _schema.GenAiRunActionParamsSchema
    });
    this.registerSubAction({
      name: _constants.SUB_ACTION.DASHBOARD,
      method: 'getDashboard',
      schema: _schema.GenAiDashboardActionParamsSchema
    });
  }
  getResponseErrorMessage(error) {
    var _error$response, _error$response2, _error$response3;
    if (!((_error$response = error.response) !== null && _error$response !== void 0 && _error$response.status)) {
      return 'Unknown API Error';
    }
    if (error.response.status === 401) {
      return 'Unauthorized API Error';
    }
    return `API Error: ${(_error$response2 = error.response) === null || _error$response2 === void 0 ? void 0 : _error$response2.status} - ${(_error$response3 = error.response) === null || _error$response3 === void 0 ? void 0 : _error$response3.statusText}`;
  }
  async runApi({
    body
  }) {
    const response = await this.request({
      url: this.url,
      method: 'post',
      responseSchema: _schema.GenAiRunActionResponseSchema,
      data: body,
      headers: {
        ...(this.provider === _constants.OpenAiProviderType.OpenAi ? {
          Authorization: `Bearer ${this.key}`
        } : {
          ['api-key']: this.key
        }),
        ['content-type']: 'application/json'
      }
    });
    return response.data;
  }
  async getDashboard({
    dashboardId
  }) {
    const privilege = await this.esClient.transport.request({
      path: '/_security/user/_has_privileges',
      method: 'POST',
      body: {
        index: [{
          names: ['.kibana-event-log-*'],
          allow_restricted_indices: true,
          privileges: ['read']
        }]
      }
    });
    if (!(privilege !== null && privilege !== void 0 && privilege.has_all_requested)) {
      return {
        available: false
      };
    }
    const response = await (0, _create_dashboard.initGenAiDashboard)({
      logger: this.logger,
      savedObjectsClient: this.savedObjectsClient,
      dashboardId
    });
    return {
      available: response.success
    };
  }
}
exports.GenAiConnector = GenAiConnector;