"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const severityOptions = [{
  value: 'critical',
  text: _i18n.i18n.translate('xpack.stackConnectors.components.xmatters.severitySelectCriticalOptionLabel', {
    defaultMessage: 'Critical'
  })
}, {
  value: 'high',
  text: _i18n.i18n.translate('xpack.stackConnectors.components.xmatters.severitySelectHighOptionLabel', {
    defaultMessage: 'High'
  })
}, {
  value: 'medium',
  text: _i18n.i18n.translate('xpack.stackConnectors.components.xmatters.severitySelectMediumOptionLabel', {
    defaultMessage: 'Medium'
  })
}, {
  value: 'low',
  text: _i18n.i18n.translate('xpack.stackConnectors.components.xmatters.severitySelectLowOptionLabel', {
    defaultMessage: 'Low'
  })
}, {
  value: 'minimal',
  text: _i18n.i18n.translate('xpack.stackConnectors.components.xmatters.severitySelectMinimalOptionLabel', {
    defaultMessage: 'Minimal'
  })
}];
const XmattersParamsFields = ({
  actionParams,
  editAction,
  index,
  messageVariables,
  errors
}) => {
  (0, _react.useEffect)(() => {
    if (!actionParams) {
      editAction('actionParams', {
        signalId: '{{rule.id}}:{{alert.id}}',
        alertActionGroupName: '{{alert.actionGroupName}}',
        ruleName: '{{rule.name}}',
        date: '{{date}}',
        spaceId: '{{rule.spaceId}}'
      }, index);
    } else {
      if (!actionParams.signalId) {
        editAction('signalId', 'test-alert', index);
      }
      if (!actionParams.alertActionGroupName) {
        editAction('alertActionGroupName', 'test-rule:test-alert', index);
      }
      if (!actionParams.ruleName) {
        editAction('ruleName', 'Test Rule', index);
      }
      if (!actionParams.date) {
        editAction('date', new Date().toISOString(), index);
      }
      if (!actionParams.spaceId) {
        editAction('spaceId', 'test-space', index);
      }
    }

    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [actionParams]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "xmattersSeverity",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.xmatters.severity', {
      defaultMessage: 'Severity'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    fullWidth: true,
    "data-test-subj": "severitySelect",
    options: severityOptions,
    hasNoInitialSelection: (0, _lodash.isUndefined)(actionParams.severity),
    value: actionParams.severity,
    onChange: e => {
      editAction('severity', e.target.value, index);
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    id: "xmattersTags",
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.stackConnectors.components.xmatters.tags', {
      defaultMessage: 'Tags'
    })
  }, /*#__PURE__*/_react.default.createElement(_public.TextFieldWithMessageVariables, {
    index: index,
    editAction: editAction,
    messageVariables: messageVariables,
    paramsProperty: 'tags',
    inputTargetValue: actionParams.tags
  })))));
};

// eslint-disable-next-line import/no-default-export
exports.default = XmattersParamsFields;
module.exports = exports.default;