"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SW_SELECT_MESSAGE_TEXT = exports.SW_ACTION_TYPE_TITLE = void 0;
exports.getConnectorType = getConnectorType;
var _react = require("react");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
const SW_SELECT_MESSAGE_TEXT = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.selectMessageText', {
  defaultMessage: 'Create record in Swimlane'
});
exports.SW_SELECT_MESSAGE_TEXT = SW_SELECT_MESSAGE_TEXT;
const SW_ACTION_TYPE_TITLE = _i18n.i18n.translate('xpack.stackConnectors.components.swimlane.connectorTypeTitle', {
  defaultMessage: 'Create Swimlane Record'
});
exports.SW_ACTION_TYPE_TITLE = SW_ACTION_TYPE_TITLE;
function getConnectorType() {
  return {
    id: '.swimlane',
    iconClass: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./logo')))),
    selectMessage: SW_SELECT_MESSAGE_TEXT,
    actionTypeTitle: SW_ACTION_TYPE_TITLE,
    validateParams: async actionParams => {
      var _actionParams$subActi, _actionParams$subActi2;
      const translations = await Promise.resolve().then(() => _interopRequireWildcard(require('./translations')));
      const errors = {
        'subActionParams.incident.ruleName': new Array(),
        'subActionParams.incident.alertId': new Array()
      };
      const validationResult = {
        errors
      };
      const hasIncident = actionParams.subActionParams && actionParams.subActionParams.incident;
      if (hasIncident && !((_actionParams$subActi = actionParams.subActionParams.incident.ruleName) !== null && _actionParams$subActi !== void 0 && _actionParams$subActi.length)) {
        errors['subActionParams.incident.ruleName'].push(translations.SW_REQUIRED_RULE_NAME);
      }
      if (hasIncident && !((_actionParams$subActi2 = actionParams.subActionParams.incident.alertId) !== null && _actionParams$subActi2 !== void 0 && _actionParams$subActi2.length)) {
        errors['subActionParams.incident.alertId'].push(translations.SW_REQUIRED_ALERT_ID);
      }
      return validationResult;
    },
    actionConnectorFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./swimlane_connectors')))),
    actionParamsFields: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./swimlane_params'))))
  };
}