"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchChannels = useFetchChannels;
var _react = require("react");
var _reactQuery = require("@tanstack/react-query");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _common = require("../../../common");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchChannels = async (http, newAuthToken) => {
  return http.post(`${_common.INTERNAL_BASE_STACK_CONNECTORS_API_PATH}/_slack_api/channels`, {
    body: JSON.stringify({
      authToken: newAuthToken
    })
  });
};
function useFetchChannels(props) {
  const {
    authToken
  } = props;
  const {
    http,
    notifications: {
      toasts
    }
  } = (0, _public.useKibana)().services;
  const queryFn = () => {
    return fetchChannels(http, authToken);
  };
  const onErrorFn = () => {
    toasts.addDanger(i18n.ERROR_FETCH_CHANNELS);
  };
  const {
    data,
    isLoading,
    isFetching
  } = (0, _reactQuery.useQuery)({
    queryKey: ['fetchChannels', authToken],
    queryFn,
    onError: onErrorFn,
    enabled: authToken.length > 0,
    refetchOnWindowFocus: false
  });
  const channels = (0, _react.useMemo)(() => {
    var _data$channels;
    return ((_data$channels = data === null || data === void 0 ? void 0 : data.channels) !== null && _data$channels !== void 0 ? _data$channels : []).map(channel => ({
      label: channel.name
    }));
  }, [data]);
  return {
    channels,
    isLoading: isLoading || isFetching
  };
}