"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var i18n = _interopRequireWildcard(require("./translations"));
var _constants = require("./constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const configFormSchema = [{
  id: 'apiUrl',
  label: i18n.API_URL_LABEL,
  isUrlField: true,
  defaultValue: _constants.DEFAULT_URL,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "The Opsgenie URL. For more information on the URL, refer to the {opsgenieAPIUrlDocs}.",
    id: "xpack.stackConnectors.components.opsgenie.apiUrlDocumentation",
    values: {
      opsgenieAPIUrlDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://docs.opsgenie.com/docs/alert-api",
        target: "_blank"
      }, i18n.OPSGENIE_DOCUMENTATION)
    }
  })
}];
const secretsFormSchema = [{
  id: 'apiKey',
  label: i18n.API_KEY_LABEL,
  isPasswordField: true,
  helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    defaultMessage: "The Opsgenie API authentication key for HTTP Basic authentication. For more details about generating Opsgenie API keys, refer to the {opsgenieAPIKeyDocs}.",
    id: "xpack.stackConnectors.components.opsgenie.apiKeyDocumentation",
    values: {
      opsgenieAPIKeyDocs: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://support.atlassian.com/opsgenie/docs/create-a-default-api-integration",
        target: "_blank"
      }, i18n.OPSGENIE_DOCUMENTATION)
    }
  })
}];
const OpsgenieConnectorFields = ({
  readOnly,
  isEdit
}) => {
  return /*#__PURE__*/_react.default.createElement(_public.SimpleConnectorForm, {
    isEdit: isEdit,
    readOnly: readOnly,
    configFormSchema: configFormSchema,
    secretsFormSchema: secretsFormSchema
  });
};

// eslint-disable-next-line import/no-default-export
exports.default = OpsgenieConnectorFields;
module.exports = exports.default;