"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Credentials = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var i18n = _interopRequireWildcard(require("./translations"));
var _credentials_api_url = require("./credentials_api_url");
var _auth_types = require("./auth_types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CredentialsComponent = ({
  readOnly,
  isLoading,
  isOAuth
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, i18n.SN_INSTANCE_LABEL)), /*#__PURE__*/_react.default.createElement(_credentials_api_url.CredentialsApiUrl, {
    readOnly: readOnly,
    isLoading: isLoading
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, i18n.AUTHENTICATION_LABEL)))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, {
    path: "config.isOAuth",
    component: _components.ToggleField,
    config: {
      defaultValue: false
    },
    componentProps: {
      hasEmptyLabelSpace: true,
      euiFieldProps: {
        label: i18n.IS_OAUTH,
        disabled: readOnly
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, isOAuth ? /*#__PURE__*/_react.default.createElement(_auth_types.OAuth, {
    readOnly: readOnly,
    isLoading: isLoading
  }) : /*#__PURE__*/_react.default.createElement(_auth_types.CredentialsAuth, {
    readOnly: readOnly,
    isLoading: isLoading
  })));
};
const Credentials = /*#__PURE__*/(0, _react.memo)(CredentialsComponent);
exports.Credentials = Credentials;