"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SUMMARY_REQUIRED = exports.SEARCH_ISSUES_PLACEHOLDER = exports.SEARCH_ISSUES_LOADING = exports.SEARCH_ISSUES_COMBO_BOX_ARIA_LABEL = exports.LABELS_WHITE_SPACES = exports.JIRA_PROJECT_KEY_LABEL = exports.JIRA_EMAIL_LABEL = exports.JIRA_API_TOKEN_LABEL = exports.ISSUE_TYPES_API_ERROR = exports.ISSUES_API_ERROR = exports.GET_ISSUE_API_ERROR = exports.FIELDS_API_ERROR = exports.API_URL_LABEL = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const API_URL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.jira.apiUrlTextFieldLabel', {
  defaultMessage: 'URL'
});
exports.API_URL_LABEL = API_URL_LABEL;
const JIRA_PROJECT_KEY_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.jira.projectKey', {
  defaultMessage: 'Project key'
});
exports.JIRA_PROJECT_KEY_LABEL = JIRA_PROJECT_KEY_LABEL;
const JIRA_EMAIL_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.jira.emailTextFieldLabel', {
  defaultMessage: 'Email address'
});
exports.JIRA_EMAIL_LABEL = JIRA_EMAIL_LABEL;
const JIRA_API_TOKEN_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.jira.apiTokenTextFieldLabel', {
  defaultMessage: 'API token'
});
exports.JIRA_API_TOKEN_LABEL = JIRA_API_TOKEN_LABEL;
const SUMMARY_REQUIRED = _i18n.i18n.translate('xpack.stackConnectors.components.jira.requiredSummaryTextField', {
  defaultMessage: 'Summary is required.'
});
exports.SUMMARY_REQUIRED = SUMMARY_REQUIRED;
const ISSUE_TYPES_API_ERROR = _i18n.i18n.translate('xpack.stackConnectors.components.jira.unableToGetIssueTypesMessage', {
  defaultMessage: 'Unable to get issue types'
});
exports.ISSUE_TYPES_API_ERROR = ISSUE_TYPES_API_ERROR;
const FIELDS_API_ERROR = _i18n.i18n.translate('xpack.stackConnectors.components.jira.unableToGetFieldsMessage', {
  defaultMessage: 'Unable to get fields'
});
exports.FIELDS_API_ERROR = FIELDS_API_ERROR;
const ISSUES_API_ERROR = _i18n.i18n.translate('xpack.stackConnectors.components.jira.unableToGetIssuesMessage', {
  defaultMessage: 'Unable to get issues'
});
exports.ISSUES_API_ERROR = ISSUES_API_ERROR;
const GET_ISSUE_API_ERROR = id => _i18n.i18n.translate('xpack.stackConnectors.components.jira.unableToGetIssueMessage', {
  defaultMessage: 'Unable to get issue with id {id}',
  values: {
    id
  }
});
exports.GET_ISSUE_API_ERROR = GET_ISSUE_API_ERROR;
const SEARCH_ISSUES_COMBO_BOX_ARIA_LABEL = _i18n.i18n.translate('xpack.stackConnectors.components.jira.searchIssuesComboBoxAriaLabel', {
  defaultMessage: 'Type to search'
});
exports.SEARCH_ISSUES_COMBO_BOX_ARIA_LABEL = SEARCH_ISSUES_COMBO_BOX_ARIA_LABEL;
const SEARCH_ISSUES_PLACEHOLDER = _i18n.i18n.translate('xpack.stackConnectors.components.jira.searchIssuesComboBoxPlaceholder', {
  defaultMessage: 'Type to search'
});
exports.SEARCH_ISSUES_PLACEHOLDER = SEARCH_ISSUES_PLACEHOLDER;
const SEARCH_ISSUES_LOADING = _i18n.i18n.translate('xpack.stackConnectors.components.jira.searchIssuesLoading', {
  defaultMessage: 'Loading...'
});
exports.SEARCH_ISSUES_LOADING = SEARCH_ISSUES_LOADING;
const LABELS_WHITE_SPACES = _i18n.i18n.translate('xpack.stackConnectors.components.jira.labelsSpacesErrorMessage', {
  defaultMessage: 'Labels cannot contain spaces.'
});
exports.LABELS_WHITE_SPACES = LABELS_WHITE_SPACES;