"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetDashboard = void 0;
var _react = require("react");
var _public = require("@kbn/triggers-actions-ui-plugin/public");
var _constants = require("./constants");
var _api = require("./api");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetDashboard = ({
  connectorId
}) => {
  const {
    dashboard,
    http,
    notifications: {
      toasts
    },
    spaces
  } = (0, _public.useKibana)().services;
  const [spaceId, setSpaceId] = (0, _react.useState)(null);
  (0, _react.useEffect)(() => {
    let didCancel = false;
    if (spaces) {
      spaces.getActiveSpace().then(space => {
        if (!didCancel) setSpaceId(space.id);
      });
    }
    return () => {
      didCancel = true;
    };
  }, [spaces]);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [dashboardUrl, setDashboardUrl] = (0, _react.useState)(null);
  const [dashboardCheckComplete, setDashboardCheckComplete] = (0, _react.useState)(false);
  const abortCtrl = (0, _react.useRef)(new AbortController());
  const setUrl = (0, _react.useCallback)(dashboardId => {
    var _dashboard$locator;
    const url = dashboard === null || dashboard === void 0 ? void 0 : (_dashboard$locator = dashboard.locator) === null || _dashboard$locator === void 0 ? void 0 : _dashboard$locator.getRedirectUrl({
      query: {
        language: 'kuery',
        query: `kibana.saved_objects: { id  : ${connectorId} }`
      },
      dashboardId
    });
    setDashboardUrl(url !== null && url !== void 0 ? url : null);
  }, [connectorId, dashboard === null || dashboard === void 0 ? void 0 : dashboard.locator]);
  (0, _react.useEffect)(() => {
    let didCancel = false;
    const fetchData = async dashboardId => {
      abortCtrl.current = new AbortController();
      if (!didCancel) setIsLoading(true);
      try {
        const res = await (0, _api.getDashboard)({
          http,
          signal: abortCtrl.current.signal,
          connectorId,
          dashboardId
        });
        if (!didCancel) {
          var _res$data;
          setDashboardCheckComplete(true);
          setIsLoading(false);
          if ((_res$data = res.data) !== null && _res$data !== void 0 && _res$data.available) {
            setUrl(dashboardId);
          }
          if (res.status && res.status === 'error') {
            var _res$serviceMessage;
            toasts.addDanger({
              title: i18n.GET_DASHBOARD_API_ERROR,
              text: `${(_res$serviceMessage = res.serviceMessage) !== null && _res$serviceMessage !== void 0 ? _res$serviceMessage : res.message}`
            });
          }
        }
      } catch (error) {
        if (!didCancel) {
          setDashboardCheckComplete(true);
          setIsLoading(false);
          toasts.addDanger({
            title: i18n.GET_DASHBOARD_API_ERROR,
            text: error.message
          });
        }
      }
    };
    if (spaceId != null && connectorId.length > 0 && !dashboardCheckComplete) {
      abortCtrl.current.abort();
      fetchData((0, _constants.getDashboardId)(spaceId));
    }
    return () => {
      didCancel = true;
      setIsLoading(false);
      abortCtrl.current.abort();
    };
  }, [connectorId, dashboardCheckComplete, dashboardUrl, http, setUrl, spaceId, toasts]);
  return {
    isLoading,
    dashboardUrl
  };
};
exports.useGetDashboard = useGetDashboard;