"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuleType = getRuleType;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _validation = require("./validation");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
function getRuleType() {
  return {
    id: '.index-threshold',
    description: _i18n.i18n.translate('xpack.stackAlerts.threshold.ui.alertType.descriptionText', {
      defaultMessage: 'Alert when an aggregated query meets the threshold.'
    }),
    iconClass: 'alert',
    documentationUrl: docLinks => docLinks.links.alerting.indexThreshold,
    ruleParamsExpression: /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('./expression')))),
    validate: _validation.validateExpression,
    defaultActionMessage: _i18n.i18n.translate('xpack.stackAlerts.threshold.ui.alertType.defaultActionMessage', {
      defaultMessage: `alert '\\{\\{alertName\\}\\}' is active for group '\\{\\{context.group\\}\\}':

- Value: \\{\\{context.value\\}\\}
- Conditions Met: \\{\\{context.conditions\\}\\} over \\{\\{params.timeWindowSize\\}\\}\\{\\{params.timeWindowUnit\\}\\}
- Timestamp: \\{\\{context.date\\}\\}`
    }),
    requiresAppContext: false
  };
}