"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteSpacesButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _confirm_delete_modal = require("../components/confirm_delete_modal");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DeleteSpacesButton extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      showConfirmDeleteModal: false,
      showConfirmRedirectModal: false
    });
    (0, _defineProperty2.default)(this, "onDeleteClick", () => {
      this.setState({
        showConfirmDeleteModal: true
      });
    });
    (0, _defineProperty2.default)(this, "getConfirmDeleteModal", () => {
      if (!this.state.showConfirmDeleteModal) {
        return null;
      }
      const {
        spacesManager
      } = this.props;
      return /*#__PURE__*/_react.default.createElement(_confirm_delete_modal.ConfirmDeleteModal, {
        space: this.props.space,
        spacesManager: spacesManager,
        onCancel: () => {
          this.setState({
            showConfirmDeleteModal: false
          });
        },
        onSuccess: () => {
          var _this$props$onDelete, _this$props;
          this.setState({
            showConfirmDeleteModal: false
          });
          (_this$props$onDelete = (_this$props = this.props).onDelete) === null || _this$props$onDelete === void 0 ? void 0 : _this$props$onDelete.call(_this$props);
        }
      });
    });
  }
  render() {
    const buttonText = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.spaces.management.deleteSpacesButton.deleteSpaceButtonLabel",
      defaultMessage: "Delete space"
    });
    let ButtonComponent = _eui.EuiButton;
    let extraProps;
    if (this.props.style === 'icon') {
      ButtonComponent = _eui.EuiButtonIcon;
      extraProps = {
        iconType: 'trash'
      };
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(ButtonComponent, (0, _extends2.default)({
      color: 'danger',
      onClick: this.onDeleteClick,
      "aria-label": _i18n.i18n.translate('xpack.spaces.management.deleteSpacesButton.deleteSpaceAriaLabel', {
        defaultMessage: 'Delete this space'
      })
    }, extraProps), buttonText), this.getConfirmDeleteModal());
  }
}
exports.DeleteSpacesButton = DeleteSpacesButton;