"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RepositoryError = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../shared_imports");
var _navigation = require("../../../../services/navigation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RepositoryError = () => {
  const history = (0, _reactRouterDom.useHistory)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageContent_Deprecated, {
    verticalPosition: "center",
    horizontalPosition: "center",
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "managementApp",
    "data-test-subj": "repositoryErrorsPrompt",
    title: /*#__PURE__*/_react.default.createElement("h1", {
      "data-test-subj": "title"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.snapshotList.emptyPrompt.errorRepositoriesTitle",
      defaultMessage: "Some repositories contain errors"
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.snapshotList.emptyPrompt.repositoryWarningDescription",
      defaultMessage: "Go to {repositoryLink} to fix the errors.",
      values: {
        repositoryLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _shared_imports.reactRouterNavigate)(history, (0, _navigation.linkToRepositories)()), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.repositoryWarningLinkText",
          defaultMessage: "Repositories"
        }))
      }
    }))
  }));
};
exports.RepositoryError = RepositoryError;