"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getQueryFromListParams = exports.getListParams = exports.DEFAULT_SNAPSHOT_LIST_PARAMS = void 0;
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// By default, we'll display the most recent snapshots at the top of the table (no query).
const DEFAULT_SNAPSHOT_LIST_PARAMS = {
  sortField: 'startTimeInMillis',
  sortDirection: 'desc',
  pageIndex: 0,
  pageSize: 20
};
exports.DEFAULT_SNAPSHOT_LIST_PARAMS = DEFAULT_SNAPSHOT_LIST_PARAMS;
const resetSearchOptions = listParams => ({
  ...listParams,
  searchField: undefined,
  searchValue: undefined,
  searchMatch: undefined,
  searchOperator: undefined
});

// to init the query for repository and policyName search passed via url
const getQueryFromListParams = (listParams, schema) => {
  const {
    searchField,
    searchValue
  } = listParams;
  if (!searchField || !searchValue) {
    return _eui.Query.MATCH_ALL;
  }
  return _eui.Query.parse(`${searchField}=${searchValue}`, {
    schema
  });
};
exports.getQueryFromListParams = getQueryFromListParams;
const getListParams = (listParams, query) => {
  if (!query) {
    return resetSearchOptions(listParams);
  }
  const clause = query.ast.clauses[0];
  if (!clause) {
    return resetSearchOptions(listParams);
  }
  // term queries (free word search) converts to snapshot name search
  if (clause.type === 'term') {
    return {
      ...listParams,
      searchField: 'snapshot',
      searchValue: String(clause.value),
      searchMatch: clause.match,
      searchOperator: 'eq'
    };
  }
  if (clause.type === 'field') {
    return {
      ...listParams,
      searchField: clause.field,
      searchValue: String(clause.value),
      searchMatch: clause.match,
      searchOperator: clause.operator
    };
  }
  return resetSearchOptions(listParams);
};
exports.getListParams = getListParams;