"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamsAndIndicesListHelpText = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DataStreamsAndIndicesListHelpText = ({
  onSelectionChange,
  selectedIndicesAndDataStreams,
  indices,
  dataStreams
}) => {
  if (selectedIndicesAndDataStreams.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepSettings.noDataStreamsOrIndicesHelpText",
      defaultMessage: "Nothing will be backed up. {selectAllLink}",
      values: {
        selectAllLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: () => {
            onSelectionChange('all');
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.snapshotRestore.policyForm.stepSettings.selectAllIndicesLink",
          defaultMessage: "Select all"
        }))
      }
    });
  }
  const indicesCount = selectedIndicesAndDataStreams.reduce((acc, v) => indices.includes(v) ? acc + 1 : acc, 0);
  const dataStreamsCount = selectedIndicesAndDataStreams.reduce((acc, v) => dataStreams.includes(v) ? acc + 1 : acc, 0);
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.snapshotRestore.policyForm.stepSettings.selectDataStreamsIndicesHelpText",
    defaultMessage: "{indicesCount} {indicesCount, plural, one {index} other {indices}} and {dataStreamsCount} {dataStreamsCount, plural, one {data stream} other {data streams}} will be backed up. {deselectAllLink}",
    values: {
      dataStreamsCount,
      indicesCount,
      deselectAllLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "deselectIndicesLink",
        onClick: () => {
          onSelectionChange('none');
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.snapshotRestore.policyForm.stepSettings.deselectAllIndicesLink",
        defaultMessage: "Deselect all"
      }))
    }
  });
};
exports.DataStreamsAndIndicesListHelpText = DataStreamsAndIndicesListHelpText;