"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IncludeGlobalStateField = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IncludeGlobalStateField = ({
  policy,
  onUpdate
}) => {
  const {
    config = {}
  } = policy;
  const onIncludeGlobalStateToggle = event => {
    var _config$featureStates;
    const {
      checked
    } = event.target;
    const hasFeatureStates = !(config !== null && config !== void 0 && (_config$featureStates = config.featureStates) !== null && _config$featureStates !== void 0 && _config$featureStates.includes(_constants.FEATURE_STATES_NONE_OPTION));
    onUpdate({
      includeGlobalState: checked,
      // if we ever include global state, we want to preselect featureStates for the users
      // so that we include all features as well.
      featureStates: checked && !hasFeatureStates ? [] : config.featureStates || []
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepSettings.includeGlobalStateDescriptionTitle",
      defaultMessage: "Include global state"
    }))),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepSettings.includeGlobalStateDescription",
      defaultMessage: "Stores the global cluster state as part of the snapshot."
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasEmptyLabelSpace: true,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "globalStateToggle",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.snapshotRestore.policyForm.stepSettings.policyIncludeGlobalStateLabel",
      defaultMessage: "Include global state"
    }),
    checked: config.includeGlobalState === undefined || config.includeGlobalState,
    onChange: onIncludeGlobalStateToggle
  })));
};
exports.IncludeGlobalStateField = IncludeGlobalStateField;