"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateCompositeSLOResponseSchema = exports.updateCompositeSLOParamsSchema = exports.getCompositeSLOParamsSchema = exports.findCompositeSLOResponseSchema = exports.findCompositeSLOParamsSchema = exports.deleteCompositeSLOParamsSchema = exports.createCompositeSLOParamsSchema = exports.compositeSLOResponseSchema = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _schema = require("../schema");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createCompositeSLOParamsSchema = t.type({
  body: t.intersection([t.type({
    name: t.string,
    timeWindow: _schema.timeWindowSchema,
    budgetingMethod: _schema.budgetingMethodSchema,
    objective: _schema.objectiveSchema,
    compositeMethod: _schema.weightedAverageCompositeMethodSchema,
    sources: t.array(_schema.weightedAverageSourceSchema)
  }), t.partial({
    id: _schema.compositeSloIdSchema,
    tags: _schema.tagsSchema
  })])
});
exports.createCompositeSLOParamsSchema = createCompositeSLOParamsSchema;
const createCompositeSLOResponseSchema = t.type({
  id: _schema.compositeSloIdSchema
});
const compositeSLOResponseSchema = t.type({
  id: _schema.compositeSloIdSchema,
  name: t.string,
  timeWindow: _schema.timeWindowSchema,
  budgetingMethod: _schema.budgetingMethodSchema,
  objective: _schema.objectiveSchema,
  compositeMethod: _schema.weightedAverageCompositeMethodSchema,
  sources: t.array(_schema.weightedAverageSourceSchema),
  tags: _schema.tagsSchema,
  createdAt: _schema.dateType,
  updatedAt: _schema.dateType
});
exports.compositeSLOResponseSchema = compositeSLOResponseSchema;
const compositeSLOWithSummaryResponseSchema = t.intersection([compositeSLOResponseSchema, t.type({
  summary: _schema.summarySchema
})]);
const updateCompositeSLOParamsSchema = t.type({
  path: t.type({
    id: _schema.compositeSloIdSchema
  }),
  body: t.partial({
    name: t.string,
    compositeMethod: _schema.weightedAverageCompositeMethodSchema,
    sources: t.array(_schema.weightedAverageSourceSchema),
    timeWindow: _schema.timeWindowSchema,
    budgetingMethod: _schema.budgetingMethodSchema,
    objective: _schema.objectiveSchema,
    tags: _schema.tagsSchema
  })
});
exports.updateCompositeSLOParamsSchema = updateCompositeSLOParamsSchema;
const updateCompositeSLOResponseSchema = compositeSLOResponseSchema;
exports.updateCompositeSLOResponseSchema = updateCompositeSLOResponseSchema;
const deleteCompositeSLOParamsSchema = t.type({
  path: t.type({
    id: _schema.compositeSloIdSchema
  })
});
exports.deleteCompositeSLOParamsSchema = deleteCompositeSLOParamsSchema;
const getCompositeSLOParamsSchema = t.type({
  path: t.type({
    id: _schema.compositeSloIdSchema
  })
});
exports.getCompositeSLOParamsSchema = getCompositeSLOParamsSchema;
const getCompositeSLOResponseSchema = compositeSLOWithSummaryResponseSchema;
const sortDirectionSchema = t.union([t.literal('asc'), t.literal('desc')]);
const sortBySchema = t.literal('creationTime');
const findCompositeSLOParamsSchema = t.partial({
  query: t.partial({
    name: t.string,
    page: t.string,
    perPage: t.string,
    sortBy: sortBySchema,
    sortDirection: sortDirectionSchema
  })
});
exports.findCompositeSLOParamsSchema = findCompositeSLOParamsSchema;
const findCompositeSLOResponseSchema = t.type({
  page: t.number,
  perPage: t.number,
  total: t.number,
  results: t.array(compositeSLOWithSummaryResponseSchema)
});
exports.findCompositeSLOResponseSchema = findCompositeSLOResponseSchema;