"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Error = void 0;
var React = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const defaultTitle = _i18n.i18n.translate('share.urlService.redirect.components.Error.title', {
  defaultMessage: 'Redirection error',
  description: 'Title displayed to user in redirect endpoint when redirection cannot be performed successfully.'
});
const Error = ({
  title = defaultTitle,
  error
}) => {
  return /*#__PURE__*/React.createElement(_eui.EuiEmptyPrompt, {
    iconType: 'error',
    iconColor: 'danger',
    title: /*#__PURE__*/React.createElement("h2", null, title),
    body: /*#__PURE__*/React.createElement(_eui.EuiCallOut, {
      color: "danger"
    }, /*#__PURE__*/React.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceAround"
    }, /*#__PURE__*/React.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/React.createElement(_eui.EuiText, {
      color: "danger"
    }, error.message))), /*#__PURE__*/React.createElement(_eui.EuiSpacer, {
      size: 'l'
    }), /*#__PURE__*/React.createElement(_eui.EuiCodeBlock, {
      language: "bash",
      className: "eui-textBreakAll",
      isCopyable: true
    }, error.stack ? error.stack : ''))
  });
};
exports.Error = Error;