"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TTYPlayerControls = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _styles = require("./styles");
var _translations = require("./translations");
var _tty_player_controls_markers = require("./tty_player_controls_markers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TTYPlayerControls = ({
  currentProcessEvent,
  processStartMarkers,
  isPlaying,
  currentLine,
  linesLength,
  onSeekLine,
  onTogglePlayback,
  onClose,
  onJumpToEvent,
  textSizer
}) => {
  const styles = (0, _styles.useStyles)();
  const commonButtonProps = {
    display: 'empty',
    size: 's',
    color: 'ghost',
    css: styles.controlButton
  };
  const onLineChange = (0, _react.useCallback)(event => {
    const line = parseInt(event.currentTarget.value || '0', 10);
    onSeekLine(line);
  }, [onSeekLine]);
  const seekToStart = (0, _react.useCallback)(() => {
    onSeekLine(0);
  }, [onSeekLine]);
  const seekToEnd = (0, _react.useCallback)(() => {
    onSeekLine(linesLength - 1);
  }, [linesLength, onSeekLine]);
  const seekToPrevProcess = (0, _react.useCallback)(() => {
    const index = currentLine > processStartMarkers[processStartMarkers.length - 1].line ? processStartMarkers.length : (0, _lodash.findIndex)(processStartMarkers, marker => marker.line >= currentLine);
    const previousMarker = processStartMarkers[index - 1];
    onSeekLine((previousMarker === null || previousMarker === void 0 ? void 0 : previousMarker.line) || 0);
  }, [processStartMarkers, onSeekLine, currentLine]);
  const seekToNextProcess = (0, _react.useCallback)(() => {
    const nextIndex = (0, _lodash.findIndex)(processStartMarkers, marker => {
      if (marker.line > currentLine) {
        return true;
      }
      return false;
    });
    const nextMarker = processStartMarkers[nextIndex];
    onSeekLine((nextMarker === null || nextMarker === void 0 ? void 0 : nextMarker.line) || linesLength - 1);
  }, [processStartMarkers, onSeekLine, linesLength, currentLine]);
  const handleViewInSession = (0, _react.useCallback)(() => {
    if (currentProcessEvent) {
      onJumpToEvent(currentProcessEvent);
      onClose();
    }
  }, [currentProcessEvent, onClose, onJumpToEvent]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    css: styles.controlsPanel,
    "data-test-subj": "sessionView:TTYPlayerControls",
    hasShadow: false,
    borderRadius: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.TTY_START
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    "data-test-subj": "sessionView:TTYPlayerControlsStart",
    iconType: "arrowStart",
    "aria-label": _translations.TTY_START,
    onClick: seekToStart
  }, commonButtonProps)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.TTY_PREVIOUS
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    "data-test-subj": "sessionView:TTYPlayerControlsPrevious",
    iconType: "arrowLeft",
    "aria-label": _translations.TTY_PREVIOUS,
    onClick: seekToPrevProcess
  }, commonButtonProps)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: isPlaying ? _translations.TTY_PAUSE : _translations.TTY_PLAY
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    "data-test-subj": "sessionView:TTYPlayerControlsPlay",
    iconType: isPlaying ? 'pause' : 'playFilled',
    "aria-label": isPlaying ? _translations.TTY_PAUSE : _translations.TTY_PLAY,
    onClick: onTogglePlayback
  }, commonButtonProps)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.TTY_NEXT
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    "data-test-subj": "sessionView:TTYPlayerControlsNext",
    iconType: "arrowRight",
    "aria-label": _translations.TTY_NEXT,
    onClick: seekToNextProcess
  }, commonButtonProps)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _translations.TTY_END
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    "data-test-subj": "sessionView:TTYPlayerControlsEnd",
    iconType: "arrowEnd",
    "aria-label": _translations.TTY_END,
    onClick: seekToEnd
  }, commonButtonProps)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      position: 'relative'
    }
  }, /*#__PURE__*/_react.default.createElement(_tty_player_controls_markers.TTYPlayerControlsMarkers, {
    processStartMarkers: processStartMarkers,
    linesLength: linesLength,
    currentLine: currentLine,
    onChange: onLineChange,
    onSeekLine: onSeekLine
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconSide: "right",
    size: "s",
    onClick: handleViewInSession,
    iconType: "arrowRight",
    "aria-label": _translations.VIEW_IN_SESSION,
    color: "ghost"
  }, _translations.VIEW_IN_SESSION)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, textSizer)));
};
exports.TTYPlayerControls = TTYPlayerControls;