"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStartedStorage = exports.FINISHED_STEPS_STORAGE_KEY = exports.ACTIVE_PRODUCTS_STORAGE_KEY = void 0;
var _storage = require("../storage");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ACTIVE_PRODUCTS_STORAGE_KEY = 'ACTIVE_PRODUCTS';
exports.ACTIVE_PRODUCTS_STORAGE_KEY = ACTIVE_PRODUCTS_STORAGE_KEY;
const FINISHED_STEPS_STORAGE_KEY = 'FINISHED_STEPS';
exports.FINISHED_STEPS_STORAGE_KEY = FINISHED_STEPS_STORAGE_KEY;
const getStartedStorage = {
  getActiveProductsFromStorage: () => {
    const activeProducts = _storage.storage.get(ACTIVE_PRODUCTS_STORAGE_KEY);
    return activeProducts !== null && activeProducts !== void 0 ? activeProducts : new Array();
  },
  toggleActiveProductsInStorage: productId => {
    var _storage$get;
    const activeProducts = (_storage$get = _storage.storage.get(ACTIVE_PRODUCTS_STORAGE_KEY)) !== null && _storage$get !== void 0 ? _storage$get : new Array();
    const index = activeProducts.indexOf(productId);
    if (index < 0) {
      activeProducts.push(productId);
    } else {
      activeProducts.splice(index, 1);
    }
    _storage.storage.set(ACTIVE_PRODUCTS_STORAGE_KEY, activeProducts);
    return activeProducts;
  },
  getFinishedStepsFromStorageByCardId: cardId => {
    var _storage$get2, _finishedSteps$cardId;
    const finishedSteps = (_storage$get2 = _storage.storage.get(FINISHED_STEPS_STORAGE_KEY)) !== null && _storage$get2 !== void 0 ? _storage$get2 : {};
    const card = (_finishedSteps$cardId = finishedSteps[cardId]) !== null && _finishedSteps$cardId !== void 0 ? _finishedSteps$cardId : new Array();
    return card;
  },
  getAllFinishedStepsFromStorage: () => {
    var _storage$get3;
    const allFinishedSteps = (_storage$get3 = _storage.storage.get(FINISHED_STEPS_STORAGE_KEY)) !== null && _storage$get3 !== void 0 ? _storage$get3 : {};
    return allFinishedSteps;
  },
  addFinishedStepToStorage: (cardId, stepId) => {
    var _storage$get4, _finishedSteps$cardId2;
    const finishedSteps = (_storage$get4 = _storage.storage.get(FINISHED_STEPS_STORAGE_KEY)) !== null && _storage$get4 !== void 0 ? _storage$get4 : {};
    const card = (_finishedSteps$cardId2 = finishedSteps[cardId]) !== null && _finishedSteps$cardId2 !== void 0 ? _finishedSteps$cardId2 : new Array();
    if (card.indexOf(stepId) < 0) {
      card.push(stepId);
      _storage.storage.set(FINISHED_STEPS_STORAGE_KEY, {
        ...finishedSteps,
        [cardId]: card
      });
    }
  },
  removeFinishedStepFromStorage: (cardId, stepId) => {
    var _storage$get5, _finishedSteps$cardId3;
    const finishedSteps = (_storage$get5 = _storage.storage.get(FINISHED_STEPS_STORAGE_KEY)) !== null && _storage$get5 !== void 0 ? _storage$get5 : {};
    const steps = (_finishedSteps$cardId3 = finishedSteps[cardId]) !== null && _finishedSteps$cardId3 !== void 0 ? _finishedSteps$cardId3 : new Array();
    const index = steps.indexOf(stepId);
    if (index >= 0) {
      steps.splice(index, 1);
    }
    _storage.storage.set(FINISHED_STEPS_STORAGE_KEY, {
      ...finishedSteps,
      [cardId]: steps
    });
  }
};
exports.getStartedStorage = getStartedStorage;