"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecuritySideNavigation = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _sharedUxPageSolutionNav = require("@kbn/shared-ux-page-solution-nav");
var _securitySolutionSideNav = require("@kbn/security-solution-side-nav");
var _use_side_nav_items = require("../../hooks/use_side_nav_items");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SecuritySideNavigation = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const sideNavItems = (0, _use_side_nav_items.useSideNavItems)();
  const selectedId = (0, _use_side_nav_items.useSideNavSelectedId)(sideNavItems);
  const [items, footerItems] = (0, _use_side_nav_items.usePartitionFooterNavItems)(sideNavItems);
  const isLoading = items.length === 0 && footerItems.length === 0;
  return isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m",
    "data-test-subj": "sideNavLoader"
  }) : /*#__PURE__*/_react.default.createElement(_sharedUxPageSolutionNav.SolutionNav, {
    canBeCollapsed: false,
    name: 'Security',
    icon: 'logoSecurity',
    children: /*#__PURE__*/_react.default.createElement(_securitySolutionSideNav.SolutionSideNav, {
      items: items,
      footerItems: footerItems,
      selectedId: selectedId,
      panelTopOffset: `calc(${euiTheme.size.l} * 2)`
    }),
    closeFlyoutButtonPosition: 'inside',
    headingProps: {
      'data-test-subj': 'securitySolutionNavHeading'
    }
  });
};
exports.SecuritySideNavigation = SecuritySideNavigation;