"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WelcomePanel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _progress = _interopRequireDefault(require("./images/progress.svg"));
var _invite = _interopRequireDefault(require("./images/invite.svg"));
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const headerCards = [{
  icon: {
    type: 'checkInCircleFilled',
    color: '#00BFB3'
  },
  title: _translations.WELCOME_PANEL_PROJECT_CREATED_TITLE,
  description: _translations.WELCOME_PANEL_PROJECT_CREATED_DESCRIPTION,
  id: 'projectCreated'
}, {
  icon: {
    type: _invite.default
  },
  title: _translations.WELCOME_PANEL_INVITE_YOUR_TEAM_TITLE,
  description: _translations.WELCOME_PANEL_INVITE_YOUR_TEAM_DESCRIPTION,
  id: 'inviteYourTeam'
}, {
  icon: {
    type: _progress.default
  },
  title: _translations.WELCOME_PANEL_PROGRESS_TRACKER_TITLE,
  id: 'progressTracker'
}];
const WelcomePanelComponent = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react.css)`
        gap: ${euiTheme.size.xl};
      `
  }, headerCards.map((item, index) => {
    return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      key: `set-up-card-${index}`
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiCard, {
      layout: "horizontal",
      icon: item.icon ? /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, (0, _extends2.default)({
        size: "xxl"
      }, item.icon, {
        "data-test-subj": `${item.id}Icon`
      })) : undefined,
      title: /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
        size: "s",
        css: (0, _react.css)`
                    font-size: 19px;
                  `
      }, /*#__PURE__*/_react2.default.createElement("span", null, item.title)),
      description: /*#__PURE__*/_react2.default.createElement("span", {
        css: (0, _react.css)`
                    color: ${euiTheme.colors.mediumShade};
                  `
      }, item.description),
      hasBorder: true,
      paddingSize: "l"
    }));
  }));
};
const WelcomePanel = /*#__PURE__*/_react2.default.memo(WelcomePanelComponent);
exports.WelcomePanel = WelcomePanel;