"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sections = exports.introductionSteps = exports.getSections = exports.ActiveConditions = void 0;
var _react = _interopRequireDefault(require("react"));
var _types = require("./types");
var i18n = _interopRequireWildcard(require("./translations"));
var _respond = _interopRequireDefault(require("./images/respond.svg"));
var _protect = _interopRequireDefault(require("./images/protect.svg"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ActiveConditions = {
  analyticsToggled: [_types.ProductId.analytics],
  cloudToggled: [_types.ProductId.cloud],
  endpointToggled: [_types.ProductId.endpoint]
};
exports.ActiveConditions = ActiveConditions;
const introductionSteps = [{
  id: _types.IntroductionSteps.watchOverviewVideo,
  title: i18n.WATCH_OVERVIEW_VIDEO_TITLE,
  description: [i18n.WATCH_OVERVIEW_VIDEO_DESCRIPTION1, i18n.WATCH_OVERVIEW_VIDEO_DESCRIPTION2, i18n.WATCH_OVERVIEW_VIDEO_DESCRIPTION3],
  splitPanel: /*#__PURE__*/_react.default.createElement("iframe", {
    allowFullScreen: true,
    className: "vidyard_iframe",
    frameBorder: "0",
    height: "100%",
    referrerPolicy: "no-referrer",
    sandbox: "allow-scripts allow-same-origin",
    scrolling: "no",
    src: "//play.vidyard.com/K6kKDBbP9SpXife9s2tHNP.html?",
    title: i18n.WATCH_OVERVIEW_VIDEO_HEADER,
    width: "100%"
  }),
  timeInMinutes: 3,
  badges: [{
    id: 'analytics',
    name: i18n.PRODUCT_BADGE_ANALYTICS
  }, {
    id: 'cloud',
    name: i18n.PRODUCT_BADGE_CLOUD
  }, {
    id: 'edr',
    name: i18n.PRODUCT_BADGE_EDR
  }]
}];
exports.introductionSteps = introductionSteps;
const sections = [{
  id: _types.SectionId.getSetUp,
  title: i18n.GET_SET_UP_TITLE,
  cards: [{
    title: i18n.INTRODUCTION_TITLE,
    icon: {
      type: 'securityApp',
      size: 'xl'
    },
    id: _types.GetSetUpCardId.introduction,
    steps: introductionSteps,
    timeInMins: introductionSteps.reduce((totalMin, {
      timeInMinutes
    }) => totalMin += timeInMinutes, 0),
    stepsLeft: introductionSteps.length
  }, {
    icon: {
      type: 'agentApp',
      size: 'xl'
    },
    title: i18n.BRING_IN_YOUR_DATA_TITLE,
    id: _types.GetSetUpCardId.bringInYourData
  }, {
    icon: {
      type: 'advancedSettingsApp',
      size: 'xl'
    },
    title: i18n.ACTIVATE_AND_CREATE_RULES_TITLE,
    id: _types.GetSetUpCardId.activateAndCreateRules
  }, {
    icon: {
      type: _protect.default,
      size: 'xl'
    },
    title: i18n.PROTECT_YOUR_ENVIRONMENT_TITLE,
    id: _types.GetSetUpCardId.protectYourEnvironmentInRuntime,
    productTypeRequired: [...ActiveConditions.cloudToggled, ...ActiveConditions.endpointToggled]
  }]
}, {
  id: _types.SectionId.getMoreFromElasticSecurity,
  title: i18n.GET_MORE_TITLE,
  cards: [{
    icon: {
      type: 'advancedSettingsApp',
      size: 'xl'
    },
    title: i18n.MASTER_THE_INVESTIGATION_TITLE,
    id: _types.GetMoreFromElasticSecurityCardId.masterTheInvestigationsWorkflow
  }, {
    icon: {
      type: _respond.default,
      size: 'xl'
    },
    title: i18n.RESPOND_TO_THREATS_TITLE,
    id: _types.GetMoreFromElasticSecurityCardId.respondToThreats
  }, {
    icon: {
      type: 'spacesApp',
      size: 'xl'
    },
    title: i18n.OPTIMIZE_YOUR_WORKSPACE_TITLE,
    id: _types.GetMoreFromElasticSecurityCardId.optimizeYourWorkSpace
  }]
}];
exports.sections = sections;
const getSections = () => sections;
exports.getSections = getSections;