"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CardStep = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _step = _interopRequireDefault(require("./images/step.svg"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CardStepComponent = ({
  sectionId,
  cardId,
  step: {
    id: stepId,
    title,
    badges,
    description,
    splitPanel
  },
  onStepClicked,
  finishedStepsByCard = new Set()
}) => {
  const [expandStep, setExpandStep] = (0, _react2.useState)(false);
  const toggleStep = (0, _react2.useCallback)(e => {
    e.preventDefault();
    setExpandStep(!expandStep);
    onStepClicked({
      stepId,
      cardId,
      sectionId
    });
  }, [cardId, expandStep, onStepClicked, sectionId, stepId]);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    color: "plain",
    grow: false,
    hasShadow: false,
    borderRadius: "none",
    paddingSize: "l"
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    css: (0, _react.css)`
          cursor: pointer;
        `,
    onClick: toggleStep
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    "data-test-subj": `${stepId}-icon`,
    type: finishedStepsByCard.has(stepId) ? 'checkInCircleFilled' : _step.default,
    size: "m"
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react2.default.createElement("strong", null, title, badges.map(badge => /*#__PURE__*/_react2.default.createElement(_eui.EuiBadge, {
    key: `${stepId}-badge-${badge.id}`,
    color: "hollow"
  }, badge.name)))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react.css)`
            align-items: end;
          `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
    size: "s",
    type: expandStep ? 'arrowDown' : 'arrowRight'
  }))), expandStep && (description || splitPanel) && /*#__PURE__*/_react2.default.createElement(_eui.EuiSplitPanel.Outer, {
    direction: "row",
    color: "plain",
    grow: false,
    hasShadow: false,
    borderRadius: "none"
  }, description && /*#__PURE__*/_react2.default.createElement(_eui.EuiSplitPanel.Inner, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "s"
  }, description === null || description === void 0 ? void 0 : description.map((desc, index) => /*#__PURE__*/_react2.default.createElement("p", {
    key: `${stepId}-description-${index}`,
    className: "eui-displayBlock"
  }, desc)))), splitPanel && /*#__PURE__*/_react2.default.createElement(_eui.EuiSplitPanel.Inner, {
    paddingSize: "none"
  }, splitPanel)));
};
CardStepComponent.displayName = 'CardStepComponent';
const CardStep = /*#__PURE__*/_react2.default.memo(CardStepComponent);
exports.CardStep = CardStep;