"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CardItem = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var i18n = _interopRequireWildcard(require("./translations"));
var _card_step = require("./card_step");
var _sections = require("./sections");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CardItemComponent = ({
  stepsLeft,
  timeInMins,
  shadow,
  euiTheme,
  onStepClicked,
  finishedSteps,
  sectionId,
  cardId
}) => {
  var _section$cards;
  const section = (0, _sections.getSections)().find(s => s.id === sectionId);
  const cardItem = section === null || section === void 0 ? void 0 : (_section$cards = section.cards) === null || _section$cards === void 0 ? void 0 : _section$cards.find(c => c.id === cardId);
  const [expandCard, setExpandCard] = (0, _react.useState)(false);
  const toggleCard = (0, _react.useCallback)(e => {
    e.preventDefault();
    setExpandCard(!expandCard);
  }, [expandCard]);
  return cardItem ? /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "m",
    css: (0, _react2.css)`
        ${shadow !== null && shadow !== void 0 ? shadow : ''};
      `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    css: (0, _react2.css)`
          gap: 14px;
          padding: ${euiTheme.size.xxs} 10px;
        `,
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    onClick: toggleCard,
    css: (0, _react2.css)`
              cursor: pointer;
            `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, cardItem.icon && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, (0, _extends2.default)({}, cardItem.icon, {
    className: "eui-alignMiddle"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    css: (0, _react2.css)`
                  line-height: ${euiTheme.base * 2}px;
                `
  }, /*#__PURE__*/_react.default.createElement("h4", null, cardItem.title))), (timeInMins != null || stepsLeft != null) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)`
                  align-items: end;
                `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    css: (0, _react2.css)`
                    line-height: ${euiTheme.base * 2}px;
                  `
  }, stepsLeft != null && stepsLeft > 0 && /*#__PURE__*/_react.default.createElement("strong", null, i18n.STEPS_LEFT(stepsLeft)), timeInMins != null && timeInMins > 0 && /*#__PURE__*/_react.default.createElement("span", null, " \u2022 ", i18n.STEP_TIME_MIN(timeInMins)))))), expandCard && cardItem.steps && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, cardItem.steps.map(step => {
    return /*#__PURE__*/_react.default.createElement(_card_step.CardStep, {
      key: step.id,
      sectionId: sectionId,
      cardId: cardItem.id,
      step: step,
      onStepClicked: onStepClicked,
      finishedStepsByCard: finishedSteps[cardItem.id]
    });
  })))) : null;
};
CardItemComponent.displayName = 'CardItemComponent';
const CardItem = /*#__PURE__*/_react.default.memo(CardItemComponent);
exports.CardItem = CardItem;