"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TryInConsoleButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _lzString = require("lz-string");
var _use_kibana = require("../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TryInConsoleButton = ({
  request
}) => {
  var _application$capabili, _application$capabili2, _url$locators$get;
  const {
    application,
    share: {
      url
    }
  } = (0, _use_kibana.useKibanaServices)();
  const canShowDevtools = !!(application !== null && application !== void 0 && (_application$capabili = application.capabilities) !== null && _application$capabili !== void 0 && (_application$capabili2 = _application$capabili.dev_tools) !== null && _application$capabili2 !== void 0 && _application$capabili2.show);
  if (!canShowDevtools || !url) return null;
  const devToolsDataUri = (0, _lzString.compressToEncodedURIComponent)(request);
  const consolePreviewLink = (_url$locators$get = url.locators.get('CONSOLE_APP_LOCATOR')) === null || _url$locators$get === void 0 ? void 0 : _url$locators$get.useUrl({
    loadFrom: `data:text/plain,${devToolsDataUri}`
  }, undefined, [request]);
  if (!consolePreviewLink) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    href: consolePreviewLink,
    iconType: "popout",
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.serverlessSearch.tryInConsoleButton",
    defaultMessage: "Try in console"
  }));
};
exports.TryInConsoleButton = TryInConsoleButton;