"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticsearchOverview = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _doc_links = require("../../../common/doc_links");
var _common = require("../../../common");
var _use_kibana = require("../hooks/use_kibana");
var _code_box = require("./code_box");
var _javascript = require("./languages/javascript");
var _languages = require("./languages/languages");
var _install_client = require("./overview_panels/install_client");
var _overview_panel = require("./overview_panels/overview_panel");
require("./overview.scss");
var _ingest_data = require("./overview_panels/ingest_data");
var _select_client = require("./overview_panels/select_client");
var _api_key = require("./api_key/api_key");
var _language_client_panel = require("./overview_panels/language_client_panel");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ELASTICSEARCH_URL_PLACEHOLDER = 'https://your_deployment_url';
const API_KEY_PLACEHOLDER = 'your_api_key';
const ElasticsearchOverview = () => {
  const [selectedLanguage, setSelectedLanguage] = (0, _react.useState)(_javascript.javascriptDefinition);
  const [clientApiKey, setClientApiKey] = (0, _react.useState)(API_KEY_PLACEHOLDER);
  const {
    application: {
      navigateToApp
    },
    cloud,
    http,
    userProfile
  } = (0, _use_kibana.useKibanaServices)();
  const elasticsearchURL = (0, _react.useMemo)(() => {
    var _cloud$elasticsearchU;
    return (_cloud$elasticsearchU = cloud === null || cloud === void 0 ? void 0 : cloud.elasticsearchUrl) !== null && _cloud$elasticsearchU !== void 0 ? _cloud$elasticsearchU : ELASTICSEARCH_URL_PLACEHOLDER;
  }, [cloud]);
  const assetBasePath = http.basePath.prepend(`/plugins/${_common.PLUGIN_ID}/assets/`);
  const codeSnippetArguments = {
    url: elasticsearchURL,
    apiKey: clientApiKey
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate, {
    offset: 0,
    grow: true,
    restrictWidth: true,
    "data-test-subj": "svlSearchOverviewPage"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    alignment: "top",
    className: "serverlessSearchHeaderSection"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "ghost"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    direction: "columnReverse",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    className: "serverlessSearchHeaderTitle",
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h1", null, _i18n.i18n.translate('xpack.serverlessSearch.header.title', {
    defaultMessage: 'Get started with Elasticsearch'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.serverlessSearch.header.greeting.title', {
    defaultMessage: 'Hi {name}!',
    values: {
      name: userProfile.user.full_name || userProfile.user.username
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.serverlessSearch.header.description', {
    defaultMessage: "Set up your programming language client, ingest some data, and you'll be ready to start searching within minutes."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    alt: "",
    src: `${assetBasePath}serverless_header.png`,
    size: "554px"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    color: "subdued",
    bottomBorder: "extended"
  }, /*#__PURE__*/_react.default.createElement(_select_client.SelectClientPanel, null, _languages.languageDefinitions.map((language, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: `panelItem.${index}`
  }, /*#__PURE__*/_react.default.createElement(_language_client_panel.LanguageClientPanel, {
    language: language,
    setSelectedLanguage: setSelectedLanguage,
    isSelectedLanguage: selectedLanguage === language
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    color: "subdued",
    bottomBorder: "extended"
  }, /*#__PURE__*/_react.default.createElement(_install_client.InstallClientPanel, {
    codeArguments: codeSnippetArguments,
    language: selectedLanguage,
    setSelectedLanguage: setSelectedLanguage
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    color: "subdued",
    bottomBorder: "extended"
  }, /*#__PURE__*/_react.default.createElement(_overview_panel.OverviewPanel, {
    description: _i18n.i18n.translate('xpack.serverlessSearch.apiKey.description', {
      defaultMessage: "You'll need these unique identifiers to securely connect to your Elasticsearch project."
    }),
    leftPanelContent: /*#__PURE__*/_react.default.createElement(_api_key.ApiKeyPanel, {
      setClientApiKey: setClientApiKey
    }),
    links: [{
      href: _doc_links.docLinks.securityApis,
      label: _i18n.i18n.translate('xpack.serverlessSearch.configureClient.basicConfigLabel', {
        defaultMessage: 'Basic configuration'
      })
    }],
    title: _i18n.i18n.translate('xpack.serverlessSearch.apiKey.title', {
      defaultMessage: 'Store your API key and Cloud ID'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    color: "subdued",
    bottomBorder: "extended"
  }, /*#__PURE__*/_react.default.createElement(_overview_panel.OverviewPanel, {
    description: _i18n.i18n.translate('xpack.serverlessSearch.configureClient.description', {
      defaultMessage: 'Initialize your client with your unique API key and Cloud ID'
    }),
    leftPanelContent: /*#__PURE__*/_react.default.createElement(_code_box.CodeBox, {
      code: "configureClient",
      codeArgs: codeSnippetArguments,
      languages: _languages.languageDefinitions,
      selectedLanguage: selectedLanguage,
      setSelectedLanguage: setSelectedLanguage
    }),
    links: [...(selectedLanguage.basicConfig ? [{
      href: selectedLanguage.basicConfig,
      label: _i18n.i18n.translate('xpack.serverlessSearch.configureClient.basicConfigLabel', {
        defaultMessage: 'Basic configuration'
      })
    }] : []), ...(selectedLanguage.advancedConfig ? [{
      href: selectedLanguage.advancedConfig,
      label: _i18n.i18n.translate('xpack.serverlessSearch.configureClient.advancedConfigLabel', {
        defaultMessage: 'Advanced configuration'
      })
    }] : [])],
    title: _i18n.i18n.translate('xpack.serverlessSearch.configureClient.title', {
      defaultMessage: 'Configure your client'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    color: "subdued",
    bottomBorder: "extended"
  }, /*#__PURE__*/_react.default.createElement(_overview_panel.OverviewPanel, {
    description: _i18n.i18n.translate('xpack.serverlessSearch.testConnection.description', {
      defaultMessage: 'Send a test request to confirm your language client and Elasticsearch instance are up and running.'
    }),
    leftPanelContent: /*#__PURE__*/_react.default.createElement(_code_box.CodeBox, {
      code: "testConnection",
      codeArgs: codeSnippetArguments,
      languages: _languages.languageDefinitions,
      selectedLanguage: selectedLanguage,
      setSelectedLanguage: setSelectedLanguage
    }),
    links: [],
    title: _i18n.i18n.translate('xpack.serverlessSearch.testConnection.title', {
      defaultMessage: 'Test your connection'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    color: "subdued",
    bottomBorder: "extended"
  }, /*#__PURE__*/_react.default.createElement(_ingest_data.IngestData, {
    codeArguments: codeSnippetArguments,
    selectedLanguage: selectedLanguage,
    setSelectedLanguage: setSelectedLanguage
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    color: "subdued",
    bottomBorder: "extended"
  }, /*#__PURE__*/_react.default.createElement(_overview_panel.OverviewPanel, {
    description: _i18n.i18n.translate('xpack.serverlessSearch.searchQuery.description', {
      defaultMessage: "Now you're ready to start experimenting with searching and performing aggregations on your Elasticsearch data."
    }),
    leftPanelContent: /*#__PURE__*/_react.default.createElement(_code_box.CodeBox, {
      code: "buildSearchQuery",
      codeArgs: codeSnippetArguments,
      languages: _languages.languageDefinitions,
      selectedLanguage: selectedLanguage,
      setSelectedLanguage: setSelectedLanguage
    }),
    links: [],
    title: _i18n.i18n.translate('xpack.serverlessSearch.searchQuery.title', {
      defaultMessage: 'Build your first search query'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    alignment: "top",
    className: "serverlessSearchFooterCardsSection"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l"
  }, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "ghost"
  }, _i18n.i18n.translate('xpack.serverlessSearch.footer.title', {
    defaultMessage: "What's next?"
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    paddingSize: "xl",
    textAlign: "left",
    title: _i18n.i18n.translate('xpack.serverlessSearch.footer.discoverCard.title', {
      defaultMessage: 'Explore and visualize your data in Discover'
    }),
    description: _i18n.i18n.translate('xpack.serverlessSearch.footer.discoverCard.description', {
      defaultMessage: 'With Discover, you can quickly search and filter your data, get information about the structure of the fields, and display your findings in a visualization.'
    }),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      onClick: () => navigateToApp('discover')
    }, _i18n.i18n.translate('xpack.serverlessSearch.footer.discoverCard.buttonText', {
      defaultMessage: 'Explore data in Discover'
    })))),
    image: /*#__PURE__*/_react.default.createElement(FooterCardImage, {
      iconSrc: `${assetBasePath}discover_icon.png`,
      backgroundSrc: `${assetBasePath}discover_bg.png`
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    paddingSize: "xl",
    textAlign: "left",
    title: _i18n.i18n.translate('xpack.serverlessSearch.footer.pipelinesCard.title', {
      defaultMessage: 'Transform your data using pipelines'
    }),
    description: _i18n.i18n.translate('xpack.serverlessSearch.footer.pipelinesCard.description', {
      defaultMessage: 'Preprocess data before indexing into Elasticsearch. Remove fields, extract values from text, or enrich your data with machine learning models like ELSER.'
    }),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary",
      onClick: () => navigateToApp('management', {
        path: '/ingest/ingest_pipelines'
      })
    }, _i18n.i18n.translate('xpack.serverlessSearch.footer.pipelinesCard.buttonText', {
      defaultMessage: 'Configure your ingest pipelines'
    })))),
    image: /*#__PURE__*/_react.default.createElement(FooterCardImage, {
      iconSrc: `${assetBasePath}transform_icon.png`,
      backgroundSrc: `${assetBasePath}transform_bg.png`
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    paddingSize: "xl",
    textAlign: "left",
    title: _i18n.i18n.translate('xpack.serverlessSearch.footer.searchUI.title', {
      defaultMessage: 'Build a user interface with Search UI'
    }),
    description: _i18n.i18n.translate('xpack.serverlessSearch.footer.searchUI.description', {
      defaultMessage: 'Search UI is a free and open source JavaScript library maintained by Elastic for the fast development of modern, engaging search experiences.'
    }),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "primary"
    }, _i18n.i18n.translate('xpack.serverlessSearch.footer.searchUI.buttonText', {
      defaultMessage: 'Build with Search UI'
    })))),
    image: /*#__PURE__*/_react.default.createElement(FooterCardImage, {
      iconSrc: `${assetBasePath}searchui_icon.png`,
      backgroundSrc: `${assetBasePath}searchui_bg.png`
    })
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.Section, {
    alignment: "top",
    className: "serverlessSearchFooter"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(FooterIcon
  // TODO: update with real link
  , {
    href: "https://elastic.co",
    imgSrc: `${assetBasePath}invite_users_icon.png`,
    title: _i18n.i18n.translate('xpack.serverlessSearch.footer.inviteUsers.title', {
      defaultMessage: 'Invite more users'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(FooterIcon
  // TODO: update with real link
  , {
    href: "https://elastic.co",
    imgSrc: `${assetBasePath}billing_icon.png`,
    title: _i18n.i18n.translate('xpack.serverlessSearch.footer.billing.title', {
      defaultMessage: 'Billing and usage'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(FooterIcon, {
    href: "https://www.elastic.co/community/",
    imgSrc: `${assetBasePath}community_icon.png`,
    title: _i18n.i18n.translate('xpack.serverlessSearch.footer.community.title', {
      defaultMessage: 'Join the community'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(FooterIcon
  // TODO: update with real link
  , {
    href: "https://www.elastic.co/kibana/feedback",
    imgSrc: `${assetBasePath}feedback_icon.png`,
    title: _i18n.i18n.translate('xpack.serverlessSearch.footer.feedback.title', {
      defaultMessage: 'Give feedback'
    })
  })))));
};
exports.ElasticsearchOverview = ElasticsearchOverview;
const FooterCardImage = ({
  iconSrc,
  backgroundSrc
}) => /*#__PURE__*/_react.default.createElement("div", {
  className: "serverlessSearchFooterCard--wrapper"
}, /*#__PURE__*/_react.default.createElement("img", {
  src: backgroundSrc,
  alt: "",
  className: "serverlessSearchFooterCard--Background"
}), /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
  size: 250,
  src: iconSrc,
  alt: "",
  wrapperProps: {
    className: 'serverlessSearchFooterCard--iconWrapper'
  },
  style: {
    width: 'auto',
    height: '100%',
    inlineSize: 'auto'
  }
}));
const FooterIcon = ({
  href,
  imgSrc,
  title
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  href: href,
  target: "_blank",
  external: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  alignItems: "center"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
  size: 120,
  src: imgSrc,
  alt: ""
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  color: "ghost"
}, /*#__PURE__*/_react.default.createElement("h5", null, title)))));