"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.languageDefinitions = void 0;
var _curl = require("./curl");
var _javascript = require("./javascript");
var _ruby = require("./ruby");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const languageDefinitionRecords = {
  [_types.Languages.CURL]: _curl.curlDefinition,
  [_types.Languages.JAVASCRIPT]: _javascript.javascriptDefinition,
  [_types.Languages.RUBY]: _ruby.rubyDefinition
};
const languageDefinitions = Object.values(languageDefinitionRecords);
exports.languageDefinitions = languageDefinitions;