"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetadataForm = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _doc_links = require("../../../../common/doc_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetadataForm = ({
  metadata,
  onChangeMetadata,
  error
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _doc_links.docLinks.metadata,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.serverlessSearch.apiKey.metadataLinkLabel', {
    defaultMessage: 'Learn how to structure role metadata'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), error && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "danger"
  }, /*#__PURE__*/_react.default.createElement("p", null, error)), /*#__PURE__*/_react.default.createElement(_public.CodeEditorField, {
    allowFullScreen: true,
    fullWidth: true,
    height: "600px",
    languageId: "json",
    isCopyable: true,
    onChange: e => onChangeMetadata(e),
    value: metadata
  }));
};
exports.MetadataForm = MetadataForm;