"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.removeIdFromItem = exports.addIdToItem = void 0;
var _uuid = require("uuid");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const addIdToItem = item => {
  const maybeId = item;
  if (maybeId.id != null) {
    return item;
  } else {
    return {
      ...item,
      id: (0, _uuid.v4)()
    };
  }
};

/**
 * This is to reverse the id you added to your arrays for ReactJS keys.
 * @param item The item to remove the id from.
 */
exports.addIdToItem = addIdToItem;
const removeIdFromItem = item => {
  const maybeId = item;
  if (maybeId.id != null) {
    const {
      id,
      ...noId
    } = maybeId;
    return noId;
  } else {
    return item;
  }
};
exports.removeIdFromItem = removeIdFromItem;