"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleTypeMappings = void 0;
var _rule_type_constants = require("./rule_type_constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Maps legacy rule types to RAC rule type IDs.
 */
const ruleTypeMappings = {
  eql: _rule_type_constants.EQL_RULE_TYPE_ID,
  machine_learning: _rule_type_constants.ML_RULE_TYPE_ID,
  query: _rule_type_constants.QUERY_RULE_TYPE_ID,
  saved_query: _rule_type_constants.SAVED_QUERY_RULE_TYPE_ID,
  threat_match: _rule_type_constants.INDICATOR_RULE_TYPE_ID,
  threshold: _rule_type_constants.THRESHOLD_RULE_TYPE_ID,
  new_terms: _rule_type_constants.NEW_TERMS_RULE_TYPE_ID
};
exports.ruleTypeMappings = ruleTypeMappings;