"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getExceptionFilterSchema = exports.exceptions = exports.exceptionListIds = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _default_namespace = require("../../common/default_namespace");
var _response = require("../../response");
var _create_exception_list_item_schema = require("../create_exception_list_item_schema");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const exceptionListId = t.type({
  exception_list_id: t.string,
  namespace_type: _default_namespace.namespaceType
});
const exceptionListIds = t.type({
  exception_list_ids: t.array(exceptionListId),
  type: t.literal('exception_list_ids')
});
exports.exceptionListIds = exceptionListIds;
const exceptions = t.type({
  exceptions: t.array(t.union([_response.exceptionListItemSchema, _create_exception_list_item_schema.createExceptionListItemSchema])),
  type: t.literal('exception_items')
});
exports.exceptions = exceptions;
const optionalExceptionParams = t.exact(t.partial({
  alias: t.string,
  chunk_size: t.number,
  exclude_exceptions: t.boolean
}));
const getExceptionFilterSchema = t.intersection([t.union([exceptions, exceptionListIds]), optionalExceptionParams]);
exports.getExceptionFilterSchema = getExceptionFilterSchema;