"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.entry = exports.entriesArrayOrUndefined = exports.entriesArray = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _entries_exist = require("../entries_exist");
var _entries_list = require("../entries_list");
var _entry_match = require("../entry_match");
var _entry_match_any = require("../entry_match_any");
var _entry_match_wildcard = require("../entry_match_wildcard");
var _entry_nested = require("../entry_nested");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// NOTE: Type nested is not included here to denote it's non-recursive nature.
// So a nested entry is really just a collection of `Entry` types.
const entry = t.union([_entry_match.entriesMatch, _entry_match_any.entriesMatchAny, _entries_list.entriesList, _entries_exist.entriesExists, _entry_match_wildcard.entriesMatchWildcard]);
exports.entry = entry;
const entriesArray = t.array(t.union([_entry_match.entriesMatch, _entry_match_any.entriesMatchAny, _entries_list.entriesList, _entries_exist.entriesExists, _entry_nested.entriesNested, _entry_match_wildcard.entriesMatchWildcard]));
exports.entriesArray = entriesArray;
const entriesArrayOrUndefined = t.union([entriesArray, t.undefined]);
exports.entriesArrayOrUndefined = entriesArrayOrUndefined;