"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildManagedUserDetailsQuery = void 0;
var _search_strategy = require("../../../../../../common/search_strategy");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildManagedUserDetailsQuery = ({
  userName,
  defaultIndex
}) => {
  const filter = [{
    term: {
      'user.name': userName
    }
  }, _search_strategy.EVENT_KIND_ASSET_FILTER];
  const dslQuery = {
    allow_no_indices: true,
    index: defaultIndex,
    ignore_unavailable: true,
    track_total_hits: false,
    body: {
      query: {
        bool: {
          filter
        }
      },
      size: 1
    },
    sort: [{
      '@timestamp': 'desc'
    }]
  };
  return dslQuery;
};
exports.buildManagedUserDetailsQuery = buildManagedUserDetailsQuery;