"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DATAVIEW_NOT_FOUND = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DATAVIEW_NOT_FOUND = dataViewId => _i18n.i18n.translate('xpack.securitySolution.riskEngine.calculateScores.dataViewNotFoundError', {
  values: {
    dataViewId
  },
  defaultMessage: 'The specified dataview ({dataViewId}) was not found. Please use an existing dataview, or omit the parameter to use the default risk inputs.'
});
exports.DATAVIEW_NOT_FOUND = DATAVIEW_NOT_FOUND;