"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRulesCount = exports.getRules = exports.getNonPackagedRulesCount = exports.getNonPackagedRules = exports.getExistingPrepackagedRules = exports.MAX_PREBUILT_RULES_COUNT = exports.FILTER_PREPACKED_RULES = exports.FILTER_NON_PREPACKED_RULES = void 0;
var _with_security_span = require("../../../../../utils/with_security_span");
var _find_rules = require("./find_rules");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_PREBUILT_RULES_COUNT = 10_000;
exports.MAX_PREBUILT_RULES_COUNT = MAX_PREBUILT_RULES_COUNT;
const FILTER_NON_PREPACKED_RULES = 'alert.attributes.params.immutable: false';
exports.FILTER_NON_PREPACKED_RULES = FILTER_NON_PREPACKED_RULES;
const FILTER_PREPACKED_RULES = 'alert.attributes.params.immutable: true';
exports.FILTER_PREPACKED_RULES = FILTER_PREPACKED_RULES;
const getNonPackagedRulesCount = async ({
  rulesClient
}) => {
  return getRulesCount({
    rulesClient,
    filter: FILTER_NON_PREPACKED_RULES
  });
};
exports.getNonPackagedRulesCount = getNonPackagedRulesCount;
const getRulesCount = async ({
  rulesClient,
  filter
}) => {
  return (0, _with_security_span.withSecuritySpan)('getRulesCount', async () => {
    const {
      total
    } = await (0, _find_rules.findRules)({
      rulesClient,
      filter,
      perPage: 0,
      page: 1,
      sortField: 'createdAt',
      sortOrder: 'desc',
      fields: undefined
    });
    return total;
  });
};
exports.getRulesCount = getRulesCount;
const getRules = async ({
  rulesClient,
  filter
}) => (0, _with_security_span.withSecuritySpan)('getRules', async () => {
  const rules = await (0, _find_rules.findRules)({
    rulesClient,
    filter,
    perPage: MAX_PREBUILT_RULES_COUNT,
    page: 1,
    sortField: 'createdAt',
    sortOrder: 'desc',
    fields: undefined
  });
  return rules.data;
});
exports.getRules = getRules;
const getNonPackagedRules = async ({
  rulesClient
}) => {
  return getRules({
    rulesClient,
    filter: FILTER_NON_PREPACKED_RULES
  });
};
exports.getNonPackagedRules = getNonPackagedRules;
const getExistingPrepackagedRules = async ({
  rulesClient
}) => {
  return getRules({
    rulesClient,
    filter: FILTER_PREPACKED_RULES
  });
};
exports.getExistingPrepackagedRules = getExistingPrepackagedRules;