"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NO_IDS_VALIDATION_ERROR = exports.ALERT_TAGS_VALIDATION_ERROR = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERT_TAGS_VALIDATION_ERROR = duplicates => _i18n.i18n.translate('xpack.securitySolution.api.alertTags.validationError', {
  values: {
    duplicates
  },
  defaultMessage: 'Duplicate tags { duplicates } were found in the tags_to_add and tags_to_remove parameters.'
});
exports.ALERT_TAGS_VALIDATION_ERROR = ALERT_TAGS_VALIDATION_ERROR;
const NO_IDS_VALIDATION_ERROR = _i18n.i18n.translate('xpack.securitySolution.api.alertTags.noAlertIds', {
  defaultMessage: 'No alert ids were provided'
});
exports.NO_IDS_VALIDATION_ERROR = NO_IDS_VALIDATION_ERROR;