"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.performTimelinesInstallation = void 0;
var _securitysolutionIoTsUtils = require("@kbn/securitysolution-io-ts-utils");
var _api = require("../../../../../common/types/timeline/api");
var _install_prepackaged_timelines = require("../../../timeline/routes/prepackaged_timelines/install_prepackaged_timelines");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const performTimelinesInstallation = async securitySolutionContext => {
  var _securitySolutionCont;
  const timeline = await (0, _install_prepackaged_timelines.installPrepackagedTimelines)((_securitySolutionCont = securitySolutionContext.getConfig()) === null || _securitySolutionCont === void 0 ? void 0 : _securitySolutionCont.maxTimelineImportExportSize, securitySolutionContext.getFrameworkRequest(), true);
  const [result, error] = (0, _securitysolutionIoTsUtils.validate)(timeline, _api.importTimelineResultSchema);
  return {
    result,
    error
  };
};
exports.performTimelinesInstallation = performTimelinesInstallation;